#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.11.1.0
visibility:           public
id:                   arch-hs-0.11.1.0-7mAfvi1TUlSKXhANWlydtv
key:                  arch-hs-0.11.1.0-7mAfvi1TUlSKXhANWlydtv
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  6cc89209b9aa0eef9229981f627486d1
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.11.1.0-7mAfvi1TUlSKXhANWlydtv
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-5YXeu67zblTJDvJ3gNHbyf
    aeson-2.1.2.1-8pX4IwvbwpcwXiIiReOQk
    algebraic-graphs-0.7-Hw3tpXFLE1e2azH9uAL8Dd
    arch-web-0.2-H5jMvpNcW9NGShQIpmoBKb base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-L447JUvNddBC7PkE6UyQyv
    conduit-extra-1.3.6-CzDgdjNDXBkKwoWdIabZpV containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-3BFQU49F1z9FcDf67J69a0
    http-client-0.7.17-4LgBMBy5FNk53TDUVte9gy
    http-client-tls-0.3.6.3-4Y419E7wE0K2HRlYAeaqTl
    megaparsec-9.6.1-iLYYaEwT1u7mxYx9b63Ap
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO
    neat-interpolation-0.5.1.4-Alk2f7BiIHUJPi54I6urfr
    optparse-simple-0.1.1.4-1Z5AehkhfOovMyd1GEP0O
    polysemy-1.9.2.0-BNLNxoIMawTHio10McINja
    prettyprinter-1.7.1-6jCWnP5jsaKCzg7tcQDjYG
    prettyprinter-ansi-terminal-1.1.3-E63Ye1CuDmE7S322wUrIHt
    servant-client-0.20-HyccBthUdlTHsKFB54Z237
    split-0.2.5-KSNJtK4iVn96dAw1dg6ivl
    tar-conduit-0.4.1-2TKjsGi7WQ5GyqzUu1oqvy template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

