#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.11.1.0
visibility:           public
id:                   arch-hs-0.11.1.0-6f8ZoaDhCW4DQxorsNX2Aj
key:                  arch-hs-0.11.1.0-6f8ZoaDhCW4DQxorsNX2Aj
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  018a61f44105191121f5c9cd5704d0dc
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.11.1.0-6f8ZoaDhCW4DQxorsNX2Aj
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-76hxB7iu2dgLeu2Kxqhnk5
    aeson-2.1.2.1-HgTvGelKFeMCs4MoB4HQQ3
    algebraic-graphs-0.7-9HlQBeI99Co4ODYGv07drG
    arch-web-0.2-GWukV7lmF7kBabkztXaOOc base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-KbvjUYjGZ6BDMEb3OqHdCI
    conduit-extra-1.3.6-6TZXJFN31N94RP34wbzUwl containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-78nTGzq02lCe1lp8Lm8cj
    http-client-0.7.17-2bmcHc0cHmODspv0lmZ3j1
    http-client-tls-0.3.6.3-4HJGt4uiE0c6Cw9rBFFelB
    megaparsec-9.6.1-D3hnMTazjD69kPahnDEjhI
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO
    neat-interpolation-0.5.1.4-I8klY5CFRbnvzjptoPDpV
    optparse-simple-0.1.1.4-3wIqn79fRzU3goe3gsouXr
    polysemy-1.9.2.0-GfmEHciR3TwGQUTqzNYhsC
    prettyprinter-1.7.1-AXDleNapq6SGrYeQXJmaAE
    prettyprinter-ansi-terminal-1.1.3-Db20N542Y0L5jpnidIh2tm
    servant-client-0.20-7BIOqv7tpug22z2BgqN87T
    split-0.2.5-1cvcRB3t1btB7X53ioPSfn
    tar-conduit-0.4.1-8su4k2IeLwtJxjRjWgDOfF template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

