#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.11.1.0
visibility:           public
id:                   arch-hs-0.11.1.0-BT3AuhYse8qDxS6t7GM4pI
key:                  arch-hs-0.11.1.0-BT3AuhYse8qDxS6t7GM4pI
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  c9a47be436b9ab51f906552dfdd6d605
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.11.1.0-BT3AuhYse8qDxS6t7GM4pI
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-BOxCLpHEbnv464iV7Wt9tY
    aeson-2.1.2.1-3xjz2RyG2JVHhJgBzFxi7A
    algebraic-graphs-0.7-FQhDAgBh2kZDKdHIhfahuu
    arch-web-0.2-8FNlTM6tQE7GWKFwFg1kYX base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-D4YiOfvDFG0FSohx4jmvQj
    conduit-extra-1.3.6-730UVkuRTVsDj6V9AWbsl9 containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-2oil6563LOVCFFKXf4pCN0
    http-client-0.7.17-AUuOyA54dq3IiMr8FLNnqs
    http-client-tls-0.3.6.3-GzwCW8R8NYVF7bq70CbU2m
    megaparsec-9.6.1-K6n3nDiAbysFzcr1mYtRG7
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO
    neat-interpolation-0.5.1.4-7qZ0KOLp4zdEQfWuvlZmDU
    optparse-simple-0.1.1.4-4SrKgIFL1nWEQmQPdY8EYh
    polysemy-1.9.2.0-FwJABxusldW1N0Q75yLnaa
    prettyprinter-1.7.1-KavgWlSYS7L7YXURHbWfqH
    prettyprinter-ansi-terminal-1.1.3-Hgen3XCgk2kK5VSvwdzMmJ
    servant-client-0.20-5gT1nQy0cu34aFP5LNjyf1
    split-0.2.5-3ghNiOjEzjd4I9aswWcGmY
    tar-conduit-0.4.1-LtjAkdYxaV2AomeTjf5V8v template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

