#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.11.1.0
visibility:           public
id:                   arch-hs-0.11.1.0-6yHoygr97P3AUmc3LPPqKo
key:                  arch-hs-0.11.1.0-6yHoygr97P3AUmc3LPPqKo
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  ad4b6bb16c29e8cacaed93d2d0458f03
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.11.1.0-6yHoygr97P3AUmc3LPPqKo
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-LH1ky1AbixJl32mO74dkD
    aeson-2.1.2.1-BogEXKsQPCa9ALgQQ034ff
    algebraic-graphs-0.7-8uiwm6EFYXDHMlMtCmfMvs
    arch-web-0.2-Teg0xJupaf6liWAsGgOBI base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-LOkHLh1PoPRERxCd5mJQIE
    conduit-extra-1.3.6-BzKgmnVk1FZLGurLLJ1Lls containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-94heQWtvs7P65XUDEmZLWF
    http-client-0.7.17-GjKLViTNtmdDUQUFfydSDc
    http-client-tls-0.3.6.3-GNrwXgXxJ3CGJjqMAHwDh1
    megaparsec-9.6.1-2HDqovyWdJD7TkiDY5U33O
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO
    neat-interpolation-0.5.1.4-Kp9Oz4fCpxaBzUbtaIUXJk
    optparse-simple-0.1.1.4-70Hy0hfYtnVL2LR3MN071d
    polysemy-1.9.2.0-6LRNx0ZbnoLIRcekXjBkQc
    prettyprinter-1.7.1-HnygYT0md3kGchHDXSnUtq
    prettyprinter-ansi-terminal-1.1.3-GLHJV3CRqnmGeQE2kGDKkf
    servant-client-0.20-8lBiQhGe1qc55uIycLv3ZY
    split-0.2.5-zycrG25TwZLo8bmb9YFUF
    tar-conduit-0.4.1-H5f6txXMO1BJVUOrXARrP template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

