#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.11.1.0
visibility:           public
id:                   arch-hs-0.11.1.0-KcJN3QjxKzgEh2gxNSaF3v
key:                  arch-hs-0.11.1.0-KcJN3QjxKzgEh2gxNSaF3v
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  0c64bad4316a9bd0ca4f96d60c615835
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.11.1.0-KcJN3QjxKzgEh2gxNSaF3v
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.11.1.0/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-LH1ky1AbixJl32mO74dkD
    aeson-2.1.2.1-G4Y2VMvw6jlHlUlOzfqhge
    algebraic-graphs-0.7-vX25dFEwTRKBJzXAui15e
    arch-web-0.2-KkAGT5pr0xl2HZ91jsouOF base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-xf7BUYu4FPC4jaCDr8wkD
    conduit-extra-1.3.6-obyvRyqfW6FPvrQZmjt1V containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-LspTxXX72517fFCS60HnR3
    http-client-0.7.17-7ke50M5l2YA8vO0Zwid8PF
    http-client-tls-0.3.6.4-JDLohsQhzsUKRvOl7N0Lps
    megaparsec-9.6.1-2HDqovyWdJD7TkiDY5U33O
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO
    neat-interpolation-0.5.1.4-2TPrZGW3AxnEPIpdPd8ouH
    optparse-simple-0.1.1.4-70Hy0hfYtnVL2LR3MN071d
    polysemy-1.9.2.0-6LRNx0ZbnoLIRcekXjBkQc
    prettyprinter-1.7.1-4Mn04lWp3HTA5zh48zv2n2
    prettyprinter-ansi-terminal-1.1.3-6Eao8UWEb6h5bk4KkwJP4W
    servant-client-0.20-DVeYWgUCHO2ELWO231mHgc
    split-0.2.5-zycrG25TwZLo8bmb9YFUF
    tar-conduit-0.4.1-H5u2YjZQqUIHzAWY7GsQmf template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

