﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/appsync/model/ErrorDetail.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace AppSync
{
namespace Model
{
  class EvaluateMappingTemplateResult
  {
  public:
    AWS_APPSYNC_API EvaluateMappingTemplateResult();
    AWS_APPSYNC_API EvaluateMappingTemplateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_APPSYNC_API EvaluateMappingTemplateResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The mapping template; this can be a request or response template.</p>
     */
    inline const Aws::String& GetEvaluationResult() const{ return m_evaluationResult; }
    inline void SetEvaluationResult(const Aws::String& value) { m_evaluationResult = value; }
    inline void SetEvaluationResult(Aws::String&& value) { m_evaluationResult = std::move(value); }
    inline void SetEvaluationResult(const char* value) { m_evaluationResult.assign(value); }
    inline EvaluateMappingTemplateResult& WithEvaluationResult(const Aws::String& value) { SetEvaluationResult(value); return *this;}
    inline EvaluateMappingTemplateResult& WithEvaluationResult(Aws::String&& value) { SetEvaluationResult(std::move(value)); return *this;}
    inline EvaluateMappingTemplateResult& WithEvaluationResult(const char* value) { SetEvaluationResult(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The <code>ErrorDetail</code> object.</p>
     */
    inline const ErrorDetail& GetError() const{ return m_error; }
    inline void SetError(const ErrorDetail& value) { m_error = value; }
    inline void SetError(ErrorDetail&& value) { m_error = std::move(value); }
    inline EvaluateMappingTemplateResult& WithError(const ErrorDetail& value) { SetError(value); return *this;}
    inline EvaluateMappingTemplateResult& WithError(ErrorDetail&& value) { SetError(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A list of logs that were generated by calls to <code>util.log.info</code> and
     * <code>util.log.error</code> in the evaluated code.</p>
     */
    inline const Aws::Vector<Aws::String>& GetLogs() const{ return m_logs; }
    inline void SetLogs(const Aws::Vector<Aws::String>& value) { m_logs = value; }
    inline void SetLogs(Aws::Vector<Aws::String>&& value) { m_logs = std::move(value); }
    inline EvaluateMappingTemplateResult& WithLogs(const Aws::Vector<Aws::String>& value) { SetLogs(value); return *this;}
    inline EvaluateMappingTemplateResult& WithLogs(Aws::Vector<Aws::String>&& value) { SetLogs(std::move(value)); return *this;}
    inline EvaluateMappingTemplateResult& AddLogs(const Aws::String& value) { m_logs.push_back(value); return *this; }
    inline EvaluateMappingTemplateResult& AddLogs(Aws::String&& value) { m_logs.push_back(std::move(value)); return *this; }
    inline EvaluateMappingTemplateResult& AddLogs(const char* value) { m_logs.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>An object available inside each resolver and function handler. A single
     * <code>stash</code> object lives through a single resolver run. Therefore, you
     * can use the stash to pass arbitrary data across request and response handlers
     * and across functions in a pipeline resolver.</p>
     */
    inline const Aws::String& GetStash() const{ return m_stash; }
    inline void SetStash(const Aws::String& value) { m_stash = value; }
    inline void SetStash(Aws::String&& value) { m_stash = std::move(value); }
    inline void SetStash(const char* value) { m_stash.assign(value); }
    inline EvaluateMappingTemplateResult& WithStash(const Aws::String& value) { SetStash(value); return *this;}
    inline EvaluateMappingTemplateResult& WithStash(Aws::String&& value) { SetStash(std::move(value)); return *this;}
    inline EvaluateMappingTemplateResult& WithStash(const char* value) { SetStash(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The list of runtime errors that are added to the GraphQL operation
     * response.</p>
     */
    inline const Aws::String& GetOutErrors() const{ return m_outErrors; }
    inline void SetOutErrors(const Aws::String& value) { m_outErrors = value; }
    inline void SetOutErrors(Aws::String&& value) { m_outErrors = std::move(value); }
    inline void SetOutErrors(const char* value) { m_outErrors.assign(value); }
    inline EvaluateMappingTemplateResult& WithOutErrors(const Aws::String& value) { SetOutErrors(value); return *this;}
    inline EvaluateMappingTemplateResult& WithOutErrors(Aws::String&& value) { SetOutErrors(std::move(value)); return *this;}
    inline EvaluateMappingTemplateResult& WithOutErrors(const char* value) { SetOutErrors(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline EvaluateMappingTemplateResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline EvaluateMappingTemplateResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline EvaluateMappingTemplateResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_evaluationResult;

    ErrorDetail m_error;

    Aws::Vector<Aws::String> m_logs;

    Aws::String m_stash;

    Aws::String m_outErrors;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
