﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apptest/AppTest_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/apptest/model/TestCaseRunSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace AppTest
{
namespace Model
{
  class ListTestRunTestCasesResult
  {
  public:
    AWS_APPTEST_API ListTestRunTestCasesResult();
    AWS_APPTEST_API ListTestRunTestCasesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_APPTEST_API ListTestRunTestCasesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The test run of the test cases.</p>
     */
    inline const Aws::Vector<TestCaseRunSummary>& GetTestRunTestCases() const{ return m_testRunTestCases; }
    inline void SetTestRunTestCases(const Aws::Vector<TestCaseRunSummary>& value) { m_testRunTestCases = value; }
    inline void SetTestRunTestCases(Aws::Vector<TestCaseRunSummary>&& value) { m_testRunTestCases = std::move(value); }
    inline ListTestRunTestCasesResult& WithTestRunTestCases(const Aws::Vector<TestCaseRunSummary>& value) { SetTestRunTestCases(value); return *this;}
    inline ListTestRunTestCasesResult& WithTestRunTestCases(Aws::Vector<TestCaseRunSummary>&& value) { SetTestRunTestCases(std::move(value)); return *this;}
    inline ListTestRunTestCasesResult& AddTestRunTestCases(const TestCaseRunSummary& value) { m_testRunTestCases.push_back(value); return *this; }
    inline ListTestRunTestCasesResult& AddTestRunTestCases(TestCaseRunSummary&& value) { m_testRunTestCases.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token from a previous request to retrieve the next page of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListTestRunTestCasesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListTestRunTestCasesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListTestRunTestCasesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListTestRunTestCasesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListTestRunTestCasesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListTestRunTestCasesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<TestCaseRunSummary> m_testRunTestCases;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace AppTest
} // namespace Aws
