﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace BedrockAgent
{
namespace Model
{

  /**
   * <p>Contains the names of the fields to which to map information about the vector
   * store.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/NeptuneAnalyticsFieldMapping">AWS
   * API Reference</a></p>
   */
  class NeptuneAnalyticsFieldMapping
  {
  public:
    AWS_BEDROCKAGENT_API NeptuneAnalyticsFieldMapping();
    AWS_BEDROCKAGENT_API NeptuneAnalyticsFieldMapping(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKAGENT_API NeptuneAnalyticsFieldMapping& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKAGENT_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The name of the field in which Amazon Bedrock stores metadata about the
     * vector store.</p>
     */
    inline const Aws::String& GetMetadataField() const{ return m_metadataField; }
    inline bool MetadataFieldHasBeenSet() const { return m_metadataFieldHasBeenSet; }
    inline void SetMetadataField(const Aws::String& value) { m_metadataFieldHasBeenSet = true; m_metadataField = value; }
    inline void SetMetadataField(Aws::String&& value) { m_metadataFieldHasBeenSet = true; m_metadataField = std::move(value); }
    inline void SetMetadataField(const char* value) { m_metadataFieldHasBeenSet = true; m_metadataField.assign(value); }
    inline NeptuneAnalyticsFieldMapping& WithMetadataField(const Aws::String& value) { SetMetadataField(value); return *this;}
    inline NeptuneAnalyticsFieldMapping& WithMetadataField(Aws::String&& value) { SetMetadataField(std::move(value)); return *this;}
    inline NeptuneAnalyticsFieldMapping& WithMetadataField(const char* value) { SetMetadataField(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the field in which Amazon Bedrock stores the raw text from your
     * data. The text is split according to the chunking strategy you choose.</p>
     */
    inline const Aws::String& GetTextField() const{ return m_textField; }
    inline bool TextFieldHasBeenSet() const { return m_textFieldHasBeenSet; }
    inline void SetTextField(const Aws::String& value) { m_textFieldHasBeenSet = true; m_textField = value; }
    inline void SetTextField(Aws::String&& value) { m_textFieldHasBeenSet = true; m_textField = std::move(value); }
    inline void SetTextField(const char* value) { m_textFieldHasBeenSet = true; m_textField.assign(value); }
    inline NeptuneAnalyticsFieldMapping& WithTextField(const Aws::String& value) { SetTextField(value); return *this;}
    inline NeptuneAnalyticsFieldMapping& WithTextField(Aws::String&& value) { SetTextField(std::move(value)); return *this;}
    inline NeptuneAnalyticsFieldMapping& WithTextField(const char* value) { SetTextField(value); return *this;}
    ///@}
  private:

    Aws::String m_metadataField;
    bool m_metadataFieldHasBeenSet = false;

    Aws::String m_textField;
    bool m_textFieldHasBeenSet = false;
  };

} // namespace Model
} // namespace BedrockAgent
} // namespace Aws
