﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dms/model/FleetAdvisorSchemaObjectResponse.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace DatabaseMigrationService
{
namespace Model
{
  class DescribeFleetAdvisorSchemaObjectSummaryResult
  {
  public:
    AWS_DATABASEMIGRATIONSERVICE_API DescribeFleetAdvisorSchemaObjectSummaryResult();
    AWS_DATABASEMIGRATIONSERVICE_API DescribeFleetAdvisorSchemaObjectSummaryResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_DATABASEMIGRATIONSERVICE_API DescribeFleetAdvisorSchemaObjectSummaryResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A collection of <code>FleetAdvisorSchemaObjectResponse</code> objects.</p>
     */
    inline const Aws::Vector<FleetAdvisorSchemaObjectResponse>& GetFleetAdvisorSchemaObjects() const{ return m_fleetAdvisorSchemaObjects; }
    inline void SetFleetAdvisorSchemaObjects(const Aws::Vector<FleetAdvisorSchemaObjectResponse>& value) { m_fleetAdvisorSchemaObjects = value; }
    inline void SetFleetAdvisorSchemaObjects(Aws::Vector<FleetAdvisorSchemaObjectResponse>&& value) { m_fleetAdvisorSchemaObjects = std::move(value); }
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& WithFleetAdvisorSchemaObjects(const Aws::Vector<FleetAdvisorSchemaObjectResponse>& value) { SetFleetAdvisorSchemaObjects(value); return *this;}
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& WithFleetAdvisorSchemaObjects(Aws::Vector<FleetAdvisorSchemaObjectResponse>&& value) { SetFleetAdvisorSchemaObjects(std::move(value)); return *this;}
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& AddFleetAdvisorSchemaObjects(const FleetAdvisorSchemaObjectResponse& value) { m_fleetAdvisorSchemaObjects.push_back(value); return *this; }
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& AddFleetAdvisorSchemaObjects(FleetAdvisorSchemaObjectResponse&& value) { m_fleetAdvisorSchemaObjects.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>If <code>NextToken</code> is returned, there are more results available. The
     * value of <code>NextToken</code> is a unique pagination token for each page. Make
     * the call again using the returned token to retrieve the next page. Keep all
     * other arguments unchanged. </p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DescribeFleetAdvisorSchemaObjectSummaryResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<FleetAdvisorSchemaObjectResponse> m_fleetAdvisorSchemaObjects;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace DatabaseMigrationService
} // namespace Aws
