﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/fms/FMS_EXPORTS.h>
#include <aws/fms/model/ResourceSet.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace FMS
{
namespace Model
{
  class GetResourceSetResult
  {
  public:
    AWS_FMS_API GetResourceSetResult();
    AWS_FMS_API GetResourceSetResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_FMS_API GetResourceSetResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>Information about the specified resource set.</p>
     */
    inline const ResourceSet& GetResourceSet() const{ return m_resourceSet; }
    inline void SetResourceSet(const ResourceSet& value) { m_resourceSet = value; }
    inline void SetResourceSet(ResourceSet&& value) { m_resourceSet = std::move(value); }
    inline GetResourceSetResult& WithResourceSet(const ResourceSet& value) { SetResourceSet(value); return *this;}
    inline GetResourceSetResult& WithResourceSet(ResourceSet&& value) { SetResourceSet(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the resource set.</p>
     */
    inline const Aws::String& GetResourceSetArn() const{ return m_resourceSetArn; }
    inline void SetResourceSetArn(const Aws::String& value) { m_resourceSetArn = value; }
    inline void SetResourceSetArn(Aws::String&& value) { m_resourceSetArn = std::move(value); }
    inline void SetResourceSetArn(const char* value) { m_resourceSetArn.assign(value); }
    inline GetResourceSetResult& WithResourceSetArn(const Aws::String& value) { SetResourceSetArn(value); return *this;}
    inline GetResourceSetResult& WithResourceSetArn(Aws::String&& value) { SetResourceSetArn(std::move(value)); return *this;}
    inline GetResourceSetResult& WithResourceSetArn(const char* value) { SetResourceSetArn(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetResourceSetResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetResourceSetResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetResourceSetResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    ResourceSet m_resourceSet;

    Aws::String m_resourceSetArn;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace FMS
} // namespace Aws
