﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/frauddetector/FraudDetector_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/frauddetector/model/DetectorVersionStatus.h>
#include <aws/frauddetector/model/RuleExecutionMode.h>
#include <aws/frauddetector/model/ModelVersion.h>
#include <aws/frauddetector/model/Rule.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace FraudDetector
{
namespace Model
{
  class GetDetectorVersionResult
  {
  public:
    AWS_FRAUDDETECTOR_API GetDetectorVersionResult();
    AWS_FRAUDDETECTOR_API GetDetectorVersionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_FRAUDDETECTOR_API GetDetectorVersionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The detector ID.</p>
     */
    inline const Aws::String& GetDetectorId() const{ return m_detectorId; }
    inline void SetDetectorId(const Aws::String& value) { m_detectorId = value; }
    inline void SetDetectorId(Aws::String&& value) { m_detectorId = std::move(value); }
    inline void SetDetectorId(const char* value) { m_detectorId.assign(value); }
    inline GetDetectorVersionResult& WithDetectorId(const Aws::String& value) { SetDetectorId(value); return *this;}
    inline GetDetectorVersionResult& WithDetectorId(Aws::String&& value) { SetDetectorId(std::move(value)); return *this;}
    inline GetDetectorVersionResult& WithDetectorId(const char* value) { SetDetectorId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The detector version ID.</p>
     */
    inline const Aws::String& GetDetectorVersionId() const{ return m_detectorVersionId; }
    inline void SetDetectorVersionId(const Aws::String& value) { m_detectorVersionId = value; }
    inline void SetDetectorVersionId(Aws::String&& value) { m_detectorVersionId = std::move(value); }
    inline void SetDetectorVersionId(const char* value) { m_detectorVersionId.assign(value); }
    inline GetDetectorVersionResult& WithDetectorVersionId(const Aws::String& value) { SetDetectorVersionId(value); return *this;}
    inline GetDetectorVersionResult& WithDetectorVersionId(Aws::String&& value) { SetDetectorVersionId(std::move(value)); return *this;}
    inline GetDetectorVersionResult& WithDetectorVersionId(const char* value) { SetDetectorVersionId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The detector version description.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }
    inline void SetDescription(const Aws::String& value) { m_description = value; }
    inline void SetDescription(Aws::String&& value) { m_description = std::move(value); }
    inline void SetDescription(const char* value) { m_description.assign(value); }
    inline GetDetectorVersionResult& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}
    inline GetDetectorVersionResult& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}
    inline GetDetectorVersionResult& WithDescription(const char* value) { SetDescription(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon SageMaker model endpoints included in the detector version.</p>
     */
    inline const Aws::Vector<Aws::String>& GetExternalModelEndpoints() const{ return m_externalModelEndpoints; }
    inline void SetExternalModelEndpoints(const Aws::Vector<Aws::String>& value) { m_externalModelEndpoints = value; }
    inline void SetExternalModelEndpoints(Aws::Vector<Aws::String>&& value) { m_externalModelEndpoints = std::move(value); }
    inline GetDetectorVersionResult& WithExternalModelEndpoints(const Aws::Vector<Aws::String>& value) { SetExternalModelEndpoints(value); return *this;}
    inline GetDetectorVersionResult& WithExternalModelEndpoints(Aws::Vector<Aws::String>&& value) { SetExternalModelEndpoints(std::move(value)); return *this;}
    inline GetDetectorVersionResult& AddExternalModelEndpoints(const Aws::String& value) { m_externalModelEndpoints.push_back(value); return *this; }
    inline GetDetectorVersionResult& AddExternalModelEndpoints(Aws::String&& value) { m_externalModelEndpoints.push_back(std::move(value)); return *this; }
    inline GetDetectorVersionResult& AddExternalModelEndpoints(const char* value) { m_externalModelEndpoints.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The model versions included in the detector version. </p>
     */
    inline const Aws::Vector<ModelVersion>& GetModelVersions() const{ return m_modelVersions; }
    inline void SetModelVersions(const Aws::Vector<ModelVersion>& value) { m_modelVersions = value; }
    inline void SetModelVersions(Aws::Vector<ModelVersion>&& value) { m_modelVersions = std::move(value); }
    inline GetDetectorVersionResult& WithModelVersions(const Aws::Vector<ModelVersion>& value) { SetModelVersions(value); return *this;}
    inline GetDetectorVersionResult& WithModelVersions(Aws::Vector<ModelVersion>&& value) { SetModelVersions(std::move(value)); return *this;}
    inline GetDetectorVersionResult& AddModelVersions(const ModelVersion& value) { m_modelVersions.push_back(value); return *this; }
    inline GetDetectorVersionResult& AddModelVersions(ModelVersion&& value) { m_modelVersions.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The rules included in the detector version.</p>
     */
    inline const Aws::Vector<Rule>& GetRules() const{ return m_rules; }
    inline void SetRules(const Aws::Vector<Rule>& value) { m_rules = value; }
    inline void SetRules(Aws::Vector<Rule>&& value) { m_rules = std::move(value); }
    inline GetDetectorVersionResult& WithRules(const Aws::Vector<Rule>& value) { SetRules(value); return *this;}
    inline GetDetectorVersionResult& WithRules(Aws::Vector<Rule>&& value) { SetRules(std::move(value)); return *this;}
    inline GetDetectorVersionResult& AddRules(const Rule& value) { m_rules.push_back(value); return *this; }
    inline GetDetectorVersionResult& AddRules(Rule&& value) { m_rules.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The status of the detector version.</p>
     */
    inline const DetectorVersionStatus& GetStatus() const{ return m_status; }
    inline void SetStatus(const DetectorVersionStatus& value) { m_status = value; }
    inline void SetStatus(DetectorVersionStatus&& value) { m_status = std::move(value); }
    inline GetDetectorVersionResult& WithStatus(const DetectorVersionStatus& value) { SetStatus(value); return *this;}
    inline GetDetectorVersionResult& WithStatus(DetectorVersionStatus&& value) { SetStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The timestamp when the detector version was last updated. </p>
     */
    inline const Aws::String& GetLastUpdatedTime() const{ return m_lastUpdatedTime; }
    inline void SetLastUpdatedTime(const Aws::String& value) { m_lastUpdatedTime = value; }
    inline void SetLastUpdatedTime(Aws::String&& value) { m_lastUpdatedTime = std::move(value); }
    inline void SetLastUpdatedTime(const char* value) { m_lastUpdatedTime.assign(value); }
    inline GetDetectorVersionResult& WithLastUpdatedTime(const Aws::String& value) { SetLastUpdatedTime(value); return *this;}
    inline GetDetectorVersionResult& WithLastUpdatedTime(Aws::String&& value) { SetLastUpdatedTime(std::move(value)); return *this;}
    inline GetDetectorVersionResult& WithLastUpdatedTime(const char* value) { SetLastUpdatedTime(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The timestamp when the detector version was created. </p>
     */
    inline const Aws::String& GetCreatedTime() const{ return m_createdTime; }
    inline void SetCreatedTime(const Aws::String& value) { m_createdTime = value; }
    inline void SetCreatedTime(Aws::String&& value) { m_createdTime = std::move(value); }
    inline void SetCreatedTime(const char* value) { m_createdTime.assign(value); }
    inline GetDetectorVersionResult& WithCreatedTime(const Aws::String& value) { SetCreatedTime(value); return *this;}
    inline GetDetectorVersionResult& WithCreatedTime(Aws::String&& value) { SetCreatedTime(std::move(value)); return *this;}
    inline GetDetectorVersionResult& WithCreatedTime(const char* value) { SetCreatedTime(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The execution mode of the rule in the dectector</p> <p>
     * <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules
     * sequentially, first to last, stopping at the first matched rule. Amazon Fraud
     * dectector then provides the outcomes for that single rule.</p> <p>
     * <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all
     * rules and returns the outcomes for all matched rules. You can define and edit
     * the rule mode at the detector version level, when it is in draft status.</p>
     */
    inline const RuleExecutionMode& GetRuleExecutionMode() const{ return m_ruleExecutionMode; }
    inline void SetRuleExecutionMode(const RuleExecutionMode& value) { m_ruleExecutionMode = value; }
    inline void SetRuleExecutionMode(RuleExecutionMode&& value) { m_ruleExecutionMode = std::move(value); }
    inline GetDetectorVersionResult& WithRuleExecutionMode(const RuleExecutionMode& value) { SetRuleExecutionMode(value); return *this;}
    inline GetDetectorVersionResult& WithRuleExecutionMode(RuleExecutionMode&& value) { SetRuleExecutionMode(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The detector version ARN.</p>
     */
    inline const Aws::String& GetArn() const{ return m_arn; }
    inline void SetArn(const Aws::String& value) { m_arn = value; }
    inline void SetArn(Aws::String&& value) { m_arn = std::move(value); }
    inline void SetArn(const char* value) { m_arn.assign(value); }
    inline GetDetectorVersionResult& WithArn(const Aws::String& value) { SetArn(value); return *this;}
    inline GetDetectorVersionResult& WithArn(Aws::String&& value) { SetArn(std::move(value)); return *this;}
    inline GetDetectorVersionResult& WithArn(const char* value) { SetArn(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetDetectorVersionResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetDetectorVersionResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetDetectorVersionResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_detectorId;

    Aws::String m_detectorVersionId;

    Aws::String m_description;

    Aws::Vector<Aws::String> m_externalModelEndpoints;

    Aws::Vector<ModelVersion> m_modelVersions;

    Aws::Vector<Rule> m_rules;

    DetectorVersionStatus m_status;

    Aws::String m_lastUpdatedTime;

    Aws::String m_createdTime;

    RuleExecutionMode m_ruleExecutionMode;

    Aws::String m_arn;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace FraudDetector
} // namespace Aws
