﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/model/CodeGenNodeArg.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Glue
{
namespace Model
{

  /**
   * <p>The location of resources.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Location">AWS API
   * Reference</a></p>
   */
  class Location
  {
  public:
    AWS_GLUE_API Location();
    AWS_GLUE_API Location(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUE_API Location& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>A JDBC location.</p>
     */
    inline const Aws::Vector<CodeGenNodeArg>& GetJdbc() const{ return m_jdbc; }
    inline bool JdbcHasBeenSet() const { return m_jdbcHasBeenSet; }
    inline void SetJdbc(const Aws::Vector<CodeGenNodeArg>& value) { m_jdbcHasBeenSet = true; m_jdbc = value; }
    inline void SetJdbc(Aws::Vector<CodeGenNodeArg>&& value) { m_jdbcHasBeenSet = true; m_jdbc = std::move(value); }
    inline Location& WithJdbc(const Aws::Vector<CodeGenNodeArg>& value) { SetJdbc(value); return *this;}
    inline Location& WithJdbc(Aws::Vector<CodeGenNodeArg>&& value) { SetJdbc(std::move(value)); return *this;}
    inline Location& AddJdbc(const CodeGenNodeArg& value) { m_jdbcHasBeenSet = true; m_jdbc.push_back(value); return *this; }
    inline Location& AddJdbc(CodeGenNodeArg&& value) { m_jdbcHasBeenSet = true; m_jdbc.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>An Amazon Simple Storage Service (Amazon S3) location.</p>
     */
    inline const Aws::Vector<CodeGenNodeArg>& GetS3() const{ return m_s3; }
    inline bool S3HasBeenSet() const { return m_s3HasBeenSet; }
    inline void SetS3(const Aws::Vector<CodeGenNodeArg>& value) { m_s3HasBeenSet = true; m_s3 = value; }
    inline void SetS3(Aws::Vector<CodeGenNodeArg>&& value) { m_s3HasBeenSet = true; m_s3 = std::move(value); }
    inline Location& WithS3(const Aws::Vector<CodeGenNodeArg>& value) { SetS3(value); return *this;}
    inline Location& WithS3(Aws::Vector<CodeGenNodeArg>&& value) { SetS3(std::move(value)); return *this;}
    inline Location& AddS3(const CodeGenNodeArg& value) { m_s3HasBeenSet = true; m_s3.push_back(value); return *this; }
    inline Location& AddS3(CodeGenNodeArg&& value) { m_s3HasBeenSet = true; m_s3.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>An Amazon DynamoDB table location.</p>
     */
    inline const Aws::Vector<CodeGenNodeArg>& GetDynamoDB() const{ return m_dynamoDB; }
    inline bool DynamoDBHasBeenSet() const { return m_dynamoDBHasBeenSet; }
    inline void SetDynamoDB(const Aws::Vector<CodeGenNodeArg>& value) { m_dynamoDBHasBeenSet = true; m_dynamoDB = value; }
    inline void SetDynamoDB(Aws::Vector<CodeGenNodeArg>&& value) { m_dynamoDBHasBeenSet = true; m_dynamoDB = std::move(value); }
    inline Location& WithDynamoDB(const Aws::Vector<CodeGenNodeArg>& value) { SetDynamoDB(value); return *this;}
    inline Location& WithDynamoDB(Aws::Vector<CodeGenNodeArg>&& value) { SetDynamoDB(std::move(value)); return *this;}
    inline Location& AddDynamoDB(const CodeGenNodeArg& value) { m_dynamoDBHasBeenSet = true; m_dynamoDB.push_back(value); return *this; }
    inline Location& AddDynamoDB(CodeGenNodeArg&& value) { m_dynamoDBHasBeenSet = true; m_dynamoDB.push_back(std::move(value)); return *this; }
    ///@}
  private:

    Aws::Vector<CodeGenNodeArg> m_jdbc;
    bool m_jdbcHasBeenSet = false;

    Aws::Vector<CodeGenNodeArg> m_s3;
    bool m_s3HasBeenSet = false;

    Aws::Vector<CodeGenNodeArg> m_dynamoDB;
    bool m_dynamoDBHasBeenSet = false;
  };

} // namespace Model
} // namespace Glue
} // namespace Aws
