﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/greengrassv2/GreengrassV2_EXPORTS.h>
#include <aws/greengrassv2/GreengrassV2Request.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/greengrassv2/model/AssociateClientDeviceWithCoreDeviceEntry.h>
#include <utility>

namespace Aws
{
namespace GreengrassV2
{
namespace Model
{

  /**
   */
  class BatchAssociateClientDeviceWithCoreDeviceRequest : public GreengrassV2Request
  {
  public:
    AWS_GREENGRASSV2_API BatchAssociateClientDeviceWithCoreDeviceRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "BatchAssociateClientDeviceWithCoreDevice"; }

    AWS_GREENGRASSV2_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The list of client devices to associate.</p>
     */
    inline const Aws::Vector<AssociateClientDeviceWithCoreDeviceEntry>& GetEntries() const{ return m_entries; }
    inline bool EntriesHasBeenSet() const { return m_entriesHasBeenSet; }
    inline void SetEntries(const Aws::Vector<AssociateClientDeviceWithCoreDeviceEntry>& value) { m_entriesHasBeenSet = true; m_entries = value; }
    inline void SetEntries(Aws::Vector<AssociateClientDeviceWithCoreDeviceEntry>&& value) { m_entriesHasBeenSet = true; m_entries = std::move(value); }
    inline BatchAssociateClientDeviceWithCoreDeviceRequest& WithEntries(const Aws::Vector<AssociateClientDeviceWithCoreDeviceEntry>& value) { SetEntries(value); return *this;}
    inline BatchAssociateClientDeviceWithCoreDeviceRequest& WithEntries(Aws::Vector<AssociateClientDeviceWithCoreDeviceEntry>&& value) { SetEntries(std::move(value)); return *this;}
    inline BatchAssociateClientDeviceWithCoreDeviceRequest& AddEntries(const AssociateClientDeviceWithCoreDeviceEntry& value) { m_entriesHasBeenSet = true; m_entries.push_back(value); return *this; }
    inline BatchAssociateClientDeviceWithCoreDeviceRequest& AddEntries(AssociateClientDeviceWithCoreDeviceEntry&& value) { m_entriesHasBeenSet = true; m_entries.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The name of the core device. This is also the name of the IoT thing.</p>
     */
    inline const Aws::String& GetCoreDeviceThingName() const{ return m_coreDeviceThingName; }
    inline bool CoreDeviceThingNameHasBeenSet() const { return m_coreDeviceThingNameHasBeenSet; }
    inline void SetCoreDeviceThingName(const Aws::String& value) { m_coreDeviceThingNameHasBeenSet = true; m_coreDeviceThingName = value; }
    inline void SetCoreDeviceThingName(Aws::String&& value) { m_coreDeviceThingNameHasBeenSet = true; m_coreDeviceThingName = std::move(value); }
    inline void SetCoreDeviceThingName(const char* value) { m_coreDeviceThingNameHasBeenSet = true; m_coreDeviceThingName.assign(value); }
    inline BatchAssociateClientDeviceWithCoreDeviceRequest& WithCoreDeviceThingName(const Aws::String& value) { SetCoreDeviceThingName(value); return *this;}
    inline BatchAssociateClientDeviceWithCoreDeviceRequest& WithCoreDeviceThingName(Aws::String&& value) { SetCoreDeviceThingName(std::move(value)); return *this;}
    inline BatchAssociateClientDeviceWithCoreDeviceRequest& WithCoreDeviceThingName(const char* value) { SetCoreDeviceThingName(value); return *this;}
    ///@}
  private:

    Aws::Vector<AssociateClientDeviceWithCoreDeviceEntry> m_entries;
    bool m_entriesHasBeenSet = false;

    Aws::String m_coreDeviceThingName;
    bool m_coreDeviceThingNameHasBeenSet = false;
  };

} // namespace Model
} // namespace GreengrassV2
} // namespace Aws
