﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/model/CreateProtectedResource.h>
#include <aws/guardduty/model/MalwareProtectionPlanActions.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <utility>
#include <aws/core/utils/UUID.h>

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

  /**
   */
  class CreateMalwareProtectionPlanRequest : public GuardDutyRequest
  {
  public:
    AWS_GUARDDUTY_API CreateMalwareProtectionPlanRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CreateMalwareProtectionPlan"; }

    AWS_GUARDDUTY_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The idempotency token for the create request.</p>
     */
    inline const Aws::String& GetClientToken() const{ return m_clientToken; }
    inline bool ClientTokenHasBeenSet() const { return m_clientTokenHasBeenSet; }
    inline void SetClientToken(const Aws::String& value) { m_clientTokenHasBeenSet = true; m_clientToken = value; }
    inline void SetClientToken(Aws::String&& value) { m_clientTokenHasBeenSet = true; m_clientToken = std::move(value); }
    inline void SetClientToken(const char* value) { m_clientTokenHasBeenSet = true; m_clientToken.assign(value); }
    inline CreateMalwareProtectionPlanRequest& WithClientToken(const Aws::String& value) { SetClientToken(value); return *this;}
    inline CreateMalwareProtectionPlanRequest& WithClientToken(Aws::String&& value) { SetClientToken(std::move(value)); return *this;}
    inline CreateMalwareProtectionPlanRequest& WithClientToken(const char* value) { SetClientToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Amazon Resource Name (ARN) of the IAM role that has the permissions to scan
     * and add tags to the associated protected resource.</p>
     */
    inline const Aws::String& GetRole() const{ return m_role; }
    inline bool RoleHasBeenSet() const { return m_roleHasBeenSet; }
    inline void SetRole(const Aws::String& value) { m_roleHasBeenSet = true; m_role = value; }
    inline void SetRole(Aws::String&& value) { m_roleHasBeenSet = true; m_role = std::move(value); }
    inline void SetRole(const char* value) { m_roleHasBeenSet = true; m_role.assign(value); }
    inline CreateMalwareProtectionPlanRequest& WithRole(const Aws::String& value) { SetRole(value); return *this;}
    inline CreateMalwareProtectionPlanRequest& WithRole(Aws::String&& value) { SetRole(std::move(value)); return *this;}
    inline CreateMalwareProtectionPlanRequest& WithRole(const char* value) { SetRole(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the protected resource that is associated with the created
     * Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported
     * protected resource.</p>
     */
    inline const CreateProtectedResource& GetProtectedResource() const{ return m_protectedResource; }
    inline bool ProtectedResourceHasBeenSet() const { return m_protectedResourceHasBeenSet; }
    inline void SetProtectedResource(const CreateProtectedResource& value) { m_protectedResourceHasBeenSet = true; m_protectedResource = value; }
    inline void SetProtectedResource(CreateProtectedResource&& value) { m_protectedResourceHasBeenSet = true; m_protectedResource = std::move(value); }
    inline CreateMalwareProtectionPlanRequest& WithProtectedResource(const CreateProtectedResource& value) { SetProtectedResource(value); return *this;}
    inline CreateMalwareProtectionPlanRequest& WithProtectedResource(CreateProtectedResource&& value) { SetProtectedResource(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about whether the tags will be added to the S3 object after
     * scanning.</p>
     */
    inline const MalwareProtectionPlanActions& GetActions() const{ return m_actions; }
    inline bool ActionsHasBeenSet() const { return m_actionsHasBeenSet; }
    inline void SetActions(const MalwareProtectionPlanActions& value) { m_actionsHasBeenSet = true; m_actions = value; }
    inline void SetActions(MalwareProtectionPlanActions&& value) { m_actionsHasBeenSet = true; m_actions = std::move(value); }
    inline CreateMalwareProtectionPlanRequest& WithActions(const MalwareProtectionPlanActions& value) { SetActions(value); return *this;}
    inline CreateMalwareProtectionPlanRequest& WithActions(MalwareProtectionPlanActions&& value) { SetActions(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Tags added to the Malware Protection plan resource. </p>
     */
    inline const Aws::Map<Aws::String, Aws::String>& GetTags() const{ return m_tags; }
    inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
    inline void SetTags(const Aws::Map<Aws::String, Aws::String>& value) { m_tagsHasBeenSet = true; m_tags = value; }
    inline void SetTags(Aws::Map<Aws::String, Aws::String>&& value) { m_tagsHasBeenSet = true; m_tags = std::move(value); }
    inline CreateMalwareProtectionPlanRequest& WithTags(const Aws::Map<Aws::String, Aws::String>& value) { SetTags(value); return *this;}
    inline CreateMalwareProtectionPlanRequest& WithTags(Aws::Map<Aws::String, Aws::String>&& value) { SetTags(std::move(value)); return *this;}
    inline CreateMalwareProtectionPlanRequest& AddTags(const Aws::String& key, const Aws::String& value) { m_tagsHasBeenSet = true; m_tags.emplace(key, value); return *this; }
    inline CreateMalwareProtectionPlanRequest& AddTags(Aws::String&& key, const Aws::String& value) { m_tagsHasBeenSet = true; m_tags.emplace(std::move(key), value); return *this; }
    inline CreateMalwareProtectionPlanRequest& AddTags(const Aws::String& key, Aws::String&& value) { m_tagsHasBeenSet = true; m_tags.emplace(key, std::move(value)); return *this; }
    inline CreateMalwareProtectionPlanRequest& AddTags(Aws::String&& key, Aws::String&& value) { m_tagsHasBeenSet = true; m_tags.emplace(std::move(key), std::move(value)); return *this; }
    inline CreateMalwareProtectionPlanRequest& AddTags(const char* key, Aws::String&& value) { m_tagsHasBeenSet = true; m_tags.emplace(key, std::move(value)); return *this; }
    inline CreateMalwareProtectionPlanRequest& AddTags(Aws::String&& key, const char* value) { m_tagsHasBeenSet = true; m_tags.emplace(std::move(key), value); return *this; }
    inline CreateMalwareProtectionPlanRequest& AddTags(const char* key, const char* value) { m_tagsHasBeenSet = true; m_tags.emplace(key, value); return *this; }
    ///@}
  private:

    Aws::String m_clientToken;
    bool m_clientTokenHasBeenSet = false;

    Aws::String m_role;
    bool m_roleHasBeenSet = false;

    CreateProtectedResource m_protectedResource;
    bool m_protectedResourceHasBeenSet = false;

    MalwareProtectionPlanActions m_actions;
    bool m_actionsHasBeenSet = false;

    Aws::Map<Aws::String, Aws::String> m_tags;
    bool m_tagsHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
