﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/model/CreateProtectedResource.h>
#include <aws/guardduty/model/MalwareProtectionPlanActions.h>
#include <aws/core/utils/DateTime.h>
#include <aws/guardduty/model/MalwareProtectionPlanStatus.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/guardduty/model/MalwareProtectionPlanStatusReason.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{
  class GetMalwareProtectionPlanResult
  {
  public:
    AWS_GUARDDUTY_API GetMalwareProtectionPlanResult();
    AWS_GUARDDUTY_API GetMalwareProtectionPlanResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_GUARDDUTY_API GetMalwareProtectionPlanResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>Amazon Resource Name (ARN) of the protected resource.</p>
     */
    inline const Aws::String& GetArn() const{ return m_arn; }
    inline void SetArn(const Aws::String& value) { m_arn = value; }
    inline void SetArn(Aws::String&& value) { m_arn = std::move(value); }
    inline void SetArn(const char* value) { m_arn.assign(value); }
    inline GetMalwareProtectionPlanResult& WithArn(const Aws::String& value) { SetArn(value); return *this;}
    inline GetMalwareProtectionPlanResult& WithArn(Aws::String&& value) { SetArn(std::move(value)); return *this;}
    inline GetMalwareProtectionPlanResult& WithArn(const char* value) { SetArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Amazon Resource Name (ARN) of the IAM role that includes the permissions to
     * scan and add tags to the associated protected resource.</p>
     */
    inline const Aws::String& GetRole() const{ return m_role; }
    inline void SetRole(const Aws::String& value) { m_role = value; }
    inline void SetRole(Aws::String&& value) { m_role = std::move(value); }
    inline void SetRole(const char* value) { m_role.assign(value); }
    inline GetMalwareProtectionPlanResult& WithRole(const Aws::String& value) { SetRole(value); return *this;}
    inline GetMalwareProtectionPlanResult& WithRole(Aws::String&& value) { SetRole(std::move(value)); return *this;}
    inline GetMalwareProtectionPlanResult& WithRole(const char* value) { SetRole(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the protected resource that is associated with the created
     * Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported
     * protected resource.</p>
     */
    inline const CreateProtectedResource& GetProtectedResource() const{ return m_protectedResource; }
    inline void SetProtectedResource(const CreateProtectedResource& value) { m_protectedResource = value; }
    inline void SetProtectedResource(CreateProtectedResource&& value) { m_protectedResource = std::move(value); }
    inline GetMalwareProtectionPlanResult& WithProtectedResource(const CreateProtectedResource& value) { SetProtectedResource(value); return *this;}
    inline GetMalwareProtectionPlanResult& WithProtectedResource(CreateProtectedResource&& value) { SetProtectedResource(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about whether the tags will be added to the S3 object after
     * scanning.</p>
     */
    inline const MalwareProtectionPlanActions& GetActions() const{ return m_actions; }
    inline void SetActions(const MalwareProtectionPlanActions& value) { m_actions = value; }
    inline void SetActions(MalwareProtectionPlanActions&& value) { m_actions = std::move(value); }
    inline GetMalwareProtectionPlanResult& WithActions(const MalwareProtectionPlanActions& value) { SetActions(value); return *this;}
    inline GetMalwareProtectionPlanResult& WithActions(MalwareProtectionPlanActions&& value) { SetActions(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The timestamp when the Malware Protection plan resource was created.</p>
     */
    inline const Aws::Utils::DateTime& GetCreatedAt() const{ return m_createdAt; }
    inline void SetCreatedAt(const Aws::Utils::DateTime& value) { m_createdAt = value; }
    inline void SetCreatedAt(Aws::Utils::DateTime&& value) { m_createdAt = std::move(value); }
    inline GetMalwareProtectionPlanResult& WithCreatedAt(const Aws::Utils::DateTime& value) { SetCreatedAt(value); return *this;}
    inline GetMalwareProtectionPlanResult& WithCreatedAt(Aws::Utils::DateTime&& value) { SetCreatedAt(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Malware Protection plan status.</p>
     */
    inline const MalwareProtectionPlanStatus& GetStatus() const{ return m_status; }
    inline void SetStatus(const MalwareProtectionPlanStatus& value) { m_status = value; }
    inline void SetStatus(MalwareProtectionPlanStatus&& value) { m_status = std::move(value); }
    inline GetMalwareProtectionPlanResult& WithStatus(const MalwareProtectionPlanStatus& value) { SetStatus(value); return *this;}
    inline GetMalwareProtectionPlanResult& WithStatus(MalwareProtectionPlanStatus&& value) { SetStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the issue code and message associated to the status of your
     * Malware Protection plan.</p>
     */
    inline const Aws::Vector<MalwareProtectionPlanStatusReason>& GetStatusReasons() const{ return m_statusReasons; }
    inline void SetStatusReasons(const Aws::Vector<MalwareProtectionPlanStatusReason>& value) { m_statusReasons = value; }
    inline void SetStatusReasons(Aws::Vector<MalwareProtectionPlanStatusReason>&& value) { m_statusReasons = std::move(value); }
    inline GetMalwareProtectionPlanResult& WithStatusReasons(const Aws::Vector<MalwareProtectionPlanStatusReason>& value) { SetStatusReasons(value); return *this;}
    inline GetMalwareProtectionPlanResult& WithStatusReasons(Aws::Vector<MalwareProtectionPlanStatusReason>&& value) { SetStatusReasons(std::move(value)); return *this;}
    inline GetMalwareProtectionPlanResult& AddStatusReasons(const MalwareProtectionPlanStatusReason& value) { m_statusReasons.push_back(value); return *this; }
    inline GetMalwareProtectionPlanResult& AddStatusReasons(MalwareProtectionPlanStatusReason&& value) { m_statusReasons.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Tags added to the Malware Protection plan resource.</p>
     */
    inline const Aws::Map<Aws::String, Aws::String>& GetTags() const{ return m_tags; }
    inline void SetTags(const Aws::Map<Aws::String, Aws::String>& value) { m_tags = value; }
    inline void SetTags(Aws::Map<Aws::String, Aws::String>&& value) { m_tags = std::move(value); }
    inline GetMalwareProtectionPlanResult& WithTags(const Aws::Map<Aws::String, Aws::String>& value) { SetTags(value); return *this;}
    inline GetMalwareProtectionPlanResult& WithTags(Aws::Map<Aws::String, Aws::String>&& value) { SetTags(std::move(value)); return *this;}
    inline GetMalwareProtectionPlanResult& AddTags(const Aws::String& key, const Aws::String& value) { m_tags.emplace(key, value); return *this; }
    inline GetMalwareProtectionPlanResult& AddTags(Aws::String&& key, const Aws::String& value) { m_tags.emplace(std::move(key), value); return *this; }
    inline GetMalwareProtectionPlanResult& AddTags(const Aws::String& key, Aws::String&& value) { m_tags.emplace(key, std::move(value)); return *this; }
    inline GetMalwareProtectionPlanResult& AddTags(Aws::String&& key, Aws::String&& value) { m_tags.emplace(std::move(key), std::move(value)); return *this; }
    inline GetMalwareProtectionPlanResult& AddTags(const char* key, Aws::String&& value) { m_tags.emplace(key, std::move(value)); return *this; }
    inline GetMalwareProtectionPlanResult& AddTags(Aws::String&& key, const char* value) { m_tags.emplace(std::move(key), value); return *this; }
    inline GetMalwareProtectionPlanResult& AddTags(const char* key, const char* value) { m_tags.emplace(key, value); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetMalwareProtectionPlanResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetMalwareProtectionPlanResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetMalwareProtectionPlanResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_arn;

    Aws::String m_role;

    CreateProtectedResource m_protectedResource;

    MalwareProtectionPlanActions m_actions;

    Aws::Utils::DateTime m_createdAt;

    MalwareProtectionPlanStatus m_status;

    Aws::Vector<MalwareProtectionPlanStatusReason> m_statusReasons;

    Aws::Map<Aws::String, Aws::String> m_tags;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
