﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/ScanResourceCriteria.h>
#include <aws/guardduty/model/EbsSnapshotPreservation.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{
  class GetMalwareScanSettingsResult
  {
  public:
    AWS_GUARDDUTY_API GetMalwareScanSettingsResult();
    AWS_GUARDDUTY_API GetMalwareScanSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_GUARDDUTY_API GetMalwareScanSettingsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>Represents the criteria to be used in the filter for scanning resources.</p>
     */
    inline const ScanResourceCriteria& GetScanResourceCriteria() const{ return m_scanResourceCriteria; }
    inline void SetScanResourceCriteria(const ScanResourceCriteria& value) { m_scanResourceCriteria = value; }
    inline void SetScanResourceCriteria(ScanResourceCriteria&& value) { m_scanResourceCriteria = std::move(value); }
    inline GetMalwareScanSettingsResult& WithScanResourceCriteria(const ScanResourceCriteria& value) { SetScanResourceCriteria(value); return *this;}
    inline GetMalwareScanSettingsResult& WithScanResourceCriteria(ScanResourceCriteria&& value) { SetScanResourceCriteria(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>An enum value representing possible snapshot preservation settings.</p>
     */
    inline const EbsSnapshotPreservation& GetEbsSnapshotPreservation() const{ return m_ebsSnapshotPreservation; }
    inline void SetEbsSnapshotPreservation(const EbsSnapshotPreservation& value) { m_ebsSnapshotPreservation = value; }
    inline void SetEbsSnapshotPreservation(EbsSnapshotPreservation&& value) { m_ebsSnapshotPreservation = std::move(value); }
    inline GetMalwareScanSettingsResult& WithEbsSnapshotPreservation(const EbsSnapshotPreservation& value) { SetEbsSnapshotPreservation(value); return *this;}
    inline GetMalwareScanSettingsResult& WithEbsSnapshotPreservation(EbsSnapshotPreservation&& value) { SetEbsSnapshotPreservation(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetMalwareScanSettingsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetMalwareScanSettingsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetMalwareScanSettingsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    ScanResourceCriteria m_scanResourceCriteria;

    EbsSnapshotPreservation m_ebsSnapshotPreservation;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
