﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>Information about the issue code and message associated to the status of your
   * Malware Protection plan.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionPlanStatusReason">AWS
   * API Reference</a></p>
   */
  class MalwareProtectionPlanStatusReason
  {
  public:
    AWS_GUARDDUTY_API MalwareProtectionPlanStatusReason();
    AWS_GUARDDUTY_API MalwareProtectionPlanStatusReason(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API MalwareProtectionPlanStatusReason& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Issue code.</p>
     */
    inline const Aws::String& GetCode() const{ return m_code; }
    inline bool CodeHasBeenSet() const { return m_codeHasBeenSet; }
    inline void SetCode(const Aws::String& value) { m_codeHasBeenSet = true; m_code = value; }
    inline void SetCode(Aws::String&& value) { m_codeHasBeenSet = true; m_code = std::move(value); }
    inline void SetCode(const char* value) { m_codeHasBeenSet = true; m_code.assign(value); }
    inline MalwareProtectionPlanStatusReason& WithCode(const Aws::String& value) { SetCode(value); return *this;}
    inline MalwareProtectionPlanStatusReason& WithCode(Aws::String&& value) { SetCode(std::move(value)); return *this;}
    inline MalwareProtectionPlanStatusReason& WithCode(const char* value) { SetCode(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Issue message that specifies the reason. For information about potential
     * troubleshooting steps, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/troubleshoot-s3-malware-protection-status-errors.html">Troubleshooting
     * Malware Protection for S3 status issues</a> in the <i>Amazon GuardDuty User
     * Guide</i>.</p>
     */
    inline const Aws::String& GetMessage() const{ return m_message; }
    inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
    inline void SetMessage(const Aws::String& value) { m_messageHasBeenSet = true; m_message = value; }
    inline void SetMessage(Aws::String&& value) { m_messageHasBeenSet = true; m_message = std::move(value); }
    inline void SetMessage(const char* value) { m_messageHasBeenSet = true; m_message.assign(value); }
    inline MalwareProtectionPlanStatusReason& WithMessage(const Aws::String& value) { SetMessage(value); return *this;}
    inline MalwareProtectionPlanStatusReason& WithMessage(Aws::String&& value) { SetMessage(std::move(value)); return *this;}
    inline MalwareProtectionPlanStatusReason& WithMessage(const char* value) { SetMessage(value); return *this;}
    ///@}
  private:

    Aws::String m_code;
    bool m_codeHasBeenSet = false;

    Aws::String m_message;
    bool m_messageHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
