﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>Information about the Malware Protection plan resource.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionPlanSummary">AWS
   * API Reference</a></p>
   */
  class MalwareProtectionPlanSummary
  {
  public:
    AWS_GUARDDUTY_API MalwareProtectionPlanSummary();
    AWS_GUARDDUTY_API MalwareProtectionPlanSummary(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API MalwareProtectionPlanSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>A unique identifier associated with Malware Protection plan.</p>
     */
    inline const Aws::String& GetMalwareProtectionPlanId() const{ return m_malwareProtectionPlanId; }
    inline bool MalwareProtectionPlanIdHasBeenSet() const { return m_malwareProtectionPlanIdHasBeenSet; }
    inline void SetMalwareProtectionPlanId(const Aws::String& value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId = value; }
    inline void SetMalwareProtectionPlanId(Aws::String&& value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId = std::move(value); }
    inline void SetMalwareProtectionPlanId(const char* value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId.assign(value); }
    inline MalwareProtectionPlanSummary& WithMalwareProtectionPlanId(const Aws::String& value) { SetMalwareProtectionPlanId(value); return *this;}
    inline MalwareProtectionPlanSummary& WithMalwareProtectionPlanId(Aws::String&& value) { SetMalwareProtectionPlanId(std::move(value)); return *this;}
    inline MalwareProtectionPlanSummary& WithMalwareProtectionPlanId(const char* value) { SetMalwareProtectionPlanId(value); return *this;}
    ///@}
  private:

    Aws::String m_malwareProtectionPlanId;
    bool m_malwareProtectionPlanIdHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
