﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/inspector/Inspector_EXPORTS.h>
#include <aws/inspector/InspectorRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Inspector
{
namespace Model
{

  /**
   */
  class PreviewAgentsRequest : public InspectorRequest
  {
  public:
    AWS_INSPECTOR_API PreviewAgentsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "PreviewAgents"; }

    AWS_INSPECTOR_API Aws::String SerializePayload() const override;

    AWS_INSPECTOR_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    ///@{
    /**
     * <p>The ARN of the assessment target whose agents you want to preview.</p>
     */
    inline const Aws::String& GetPreviewAgentsArn() const{ return m_previewAgentsArn; }
    inline bool PreviewAgentsArnHasBeenSet() const { return m_previewAgentsArnHasBeenSet; }
    inline void SetPreviewAgentsArn(const Aws::String& value) { m_previewAgentsArnHasBeenSet = true; m_previewAgentsArn = value; }
    inline void SetPreviewAgentsArn(Aws::String&& value) { m_previewAgentsArnHasBeenSet = true; m_previewAgentsArn = std::move(value); }
    inline void SetPreviewAgentsArn(const char* value) { m_previewAgentsArnHasBeenSet = true; m_previewAgentsArn.assign(value); }
    inline PreviewAgentsRequest& WithPreviewAgentsArn(const Aws::String& value) { SetPreviewAgentsArn(value); return *this;}
    inline PreviewAgentsRequest& WithPreviewAgentsArn(Aws::String&& value) { SetPreviewAgentsArn(std::move(value)); return *this;}
    inline PreviewAgentsRequest& WithPreviewAgentsArn(const char* value) { SetPreviewAgentsArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>You can use this parameter when paginating results. Set the value of this
     * parameter to null on your first call to the <b>PreviewAgents</b> action.
     * Subsequent calls to the action fill <b>nextToken</b> in the request with the
     * value of <b>NextToken</b> from the previous response to continue listing
     * data.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
    inline void SetNextToken(const Aws::String& value) { m_nextTokenHasBeenSet = true; m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextTokenHasBeenSet = true; m_nextToken.assign(value); }
    inline PreviewAgentsRequest& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline PreviewAgentsRequest& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline PreviewAgentsRequest& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>You can use this parameter to indicate the maximum number of items you want
     * in the response. The default value is 10. The maximum value is 500.</p>
     */
    inline int GetMaxResults() const{ return m_maxResults; }
    inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
    inline void SetMaxResults(int value) { m_maxResultsHasBeenSet = true; m_maxResults = value; }
    inline PreviewAgentsRequest& WithMaxResults(int value) { SetMaxResults(value); return *this;}
    ///@}
  private:

    Aws::String m_previewAgentsArn;
    bool m_previewAgentsArnHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    int m_maxResults;
    bool m_maxResultsHasBeenSet = false;
  };

} // namespace Model
} // namespace Inspector
} // namespace Aws
