﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Inspector2
{
namespace Model
{

  /**
   * <p>Contains information on when this exploit was observed.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ExploitObserved">AWS
   * API Reference</a></p>
   */
  class ExploitObserved
  {
  public:
    AWS_INSPECTOR2_API ExploitObserved();
    AWS_INSPECTOR2_API ExploitObserved(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API ExploitObserved& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The date an time when the exploit was first seen.</p>
     */
    inline const Aws::Utils::DateTime& GetFirstSeen() const{ return m_firstSeen; }
    inline bool FirstSeenHasBeenSet() const { return m_firstSeenHasBeenSet; }
    inline void SetFirstSeen(const Aws::Utils::DateTime& value) { m_firstSeenHasBeenSet = true; m_firstSeen = value; }
    inline void SetFirstSeen(Aws::Utils::DateTime&& value) { m_firstSeenHasBeenSet = true; m_firstSeen = std::move(value); }
    inline ExploitObserved& WithFirstSeen(const Aws::Utils::DateTime& value) { SetFirstSeen(value); return *this;}
    inline ExploitObserved& WithFirstSeen(Aws::Utils::DateTime&& value) { SetFirstSeen(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date an time when the exploit was last seen.</p>
     */
    inline const Aws::Utils::DateTime& GetLastSeen() const{ return m_lastSeen; }
    inline bool LastSeenHasBeenSet() const { return m_lastSeenHasBeenSet; }
    inline void SetLastSeen(const Aws::Utils::DateTime& value) { m_lastSeenHasBeenSet = true; m_lastSeen = value; }
    inline void SetLastSeen(Aws::Utils::DateTime&& value) { m_lastSeenHasBeenSet = true; m_lastSeen = std::move(value); }
    inline ExploitObserved& WithLastSeen(const Aws::Utils::DateTime& value) { SetLastSeen(value); return *this;}
    inline ExploitObserved& WithLastSeen(Aws::Utils::DateTime&& value) { SetLastSeen(std::move(value)); return *this;}
    ///@}
  private:

    Aws::Utils::DateTime m_firstSeen;
    bool m_firstSeenHasBeenSet = false;

    Aws::Utils::DateTime m_lastSeen;
    bool m_lastSeenHasBeenSet = false;
  };

} // namespace Model
} // namespace Inspector2
} // namespace Aws
