﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/inspector2/model/AtigData.h>
#include <aws/inspector2/model/CisaData.h>
#include <aws/inspector2/model/Cvss2.h>
#include <aws/inspector2/model/Cvss3.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/inspector2/model/Epss.h>
#include <aws/inspector2/model/ExploitObserved.h>
#include <aws/inspector2/model/VulnerabilitySource.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Inspector2
{
namespace Model
{

  /**
   * <p>Contains details about a specific vulnerability Amazon Inspector can
   * detect.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Vulnerability">AWS
   * API Reference</a></p>
   */
  class Vulnerability
  {
  public:
    AWS_INSPECTOR2_API Vulnerability();
    AWS_INSPECTOR2_API Vulnerability(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Vulnerability& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>An object that contains information about the Amazon Web Services Threat
     * Intel Group (ATIG) details for the vulnerability.</p>
     */
    inline const AtigData& GetAtigData() const{ return m_atigData; }
    inline bool AtigDataHasBeenSet() const { return m_atigDataHasBeenSet; }
    inline void SetAtigData(const AtigData& value) { m_atigDataHasBeenSet = true; m_atigData = value; }
    inline void SetAtigData(AtigData&& value) { m_atigDataHasBeenSet = true; m_atigData = std::move(value); }
    inline Vulnerability& WithAtigData(const AtigData& value) { SetAtigData(value); return *this;}
    inline Vulnerability& WithAtigData(AtigData&& value) { SetAtigData(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>An object that contains the Cybersecurity and Infrastructure Security Agency
     * (CISA) details for the vulnerability.</p>
     */
    inline const CisaData& GetCisaData() const{ return m_cisaData; }
    inline bool CisaDataHasBeenSet() const { return m_cisaDataHasBeenSet; }
    inline void SetCisaData(const CisaData& value) { m_cisaDataHasBeenSet = true; m_cisaData = value; }
    inline void SetCisaData(CisaData&& value) { m_cisaDataHasBeenSet = true; m_cisaData = std::move(value); }
    inline Vulnerability& WithCisaData(const CisaData& value) { SetCisaData(value); return *this;}
    inline Vulnerability& WithCisaData(CisaData&& value) { SetCisaData(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 2 details for the vulnerability.</p>
     */
    inline const Cvss2& GetCvss2() const{ return m_cvss2; }
    inline bool Cvss2HasBeenSet() const { return m_cvss2HasBeenSet; }
    inline void SetCvss2(const Cvss2& value) { m_cvss2HasBeenSet = true; m_cvss2 = value; }
    inline void SetCvss2(Cvss2&& value) { m_cvss2HasBeenSet = true; m_cvss2 = std::move(value); }
    inline Vulnerability& WithCvss2(const Cvss2& value) { SetCvss2(value); return *this;}
    inline Vulnerability& WithCvss2(Cvss2&& value) { SetCvss2(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>An object that contains the Common Vulnerability Scoring System (CVSS)
     * Version 3 details for the vulnerability.</p>
     */
    inline const Cvss3& GetCvss3() const{ return m_cvss3; }
    inline bool Cvss3HasBeenSet() const { return m_cvss3HasBeenSet; }
    inline void SetCvss3(const Cvss3& value) { m_cvss3HasBeenSet = true; m_cvss3 = value; }
    inline void SetCvss3(Cvss3&& value) { m_cvss3HasBeenSet = true; m_cvss3 = std::move(value); }
    inline Vulnerability& WithCvss3(const Cvss3& value) { SetCvss3(value); return *this;}
    inline Vulnerability& WithCvss3(Cvss3&& value) { SetCvss3(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetCwes() const{ return m_cwes; }
    inline bool CwesHasBeenSet() const { return m_cwesHasBeenSet; }
    inline void SetCwes(const Aws::Vector<Aws::String>& value) { m_cwesHasBeenSet = true; m_cwes = value; }
    inline void SetCwes(Aws::Vector<Aws::String>&& value) { m_cwesHasBeenSet = true; m_cwes = std::move(value); }
    inline Vulnerability& WithCwes(const Aws::Vector<Aws::String>& value) { SetCwes(value); return *this;}
    inline Vulnerability& WithCwes(Aws::Vector<Aws::String>&& value) { SetCwes(std::move(value)); return *this;}
    inline Vulnerability& AddCwes(const Aws::String& value) { m_cwesHasBeenSet = true; m_cwes.push_back(value); return *this; }
    inline Vulnerability& AddCwes(Aws::String&& value) { m_cwesHasBeenSet = true; m_cwes.push_back(std::move(value)); return *this; }
    inline Vulnerability& AddCwes(const char* value) { m_cwesHasBeenSet = true; m_cwes.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>A description of the vulnerability.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }
    inline Vulnerability& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}
    inline Vulnerability& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}
    inline Vulnerability& WithDescription(const char* value) { SetDescription(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Platforms that the vulnerability can be detected on.</p>
     */
    inline const Aws::Vector<Aws::String>& GetDetectionPlatforms() const{ return m_detectionPlatforms; }
    inline bool DetectionPlatformsHasBeenSet() const { return m_detectionPlatformsHasBeenSet; }
    inline void SetDetectionPlatforms(const Aws::Vector<Aws::String>& value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms = value; }
    inline void SetDetectionPlatforms(Aws::Vector<Aws::String>&& value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms = std::move(value); }
    inline Vulnerability& WithDetectionPlatforms(const Aws::Vector<Aws::String>& value) { SetDetectionPlatforms(value); return *this;}
    inline Vulnerability& WithDetectionPlatforms(Aws::Vector<Aws::String>&& value) { SetDetectionPlatforms(std::move(value)); return *this;}
    inline Vulnerability& AddDetectionPlatforms(const Aws::String& value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms.push_back(value); return *this; }
    inline Vulnerability& AddDetectionPlatforms(Aws::String&& value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms.push_back(std::move(value)); return *this; }
    inline Vulnerability& AddDetectionPlatforms(const char* value) { m_detectionPlatformsHasBeenSet = true; m_detectionPlatforms.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>An object that contains the Exploit Prediction Scoring System (EPSS) score
     * for a vulnerability.</p>
     */
    inline const Epss& GetEpss() const{ return m_epss; }
    inline bool EpssHasBeenSet() const { return m_epssHasBeenSet; }
    inline void SetEpss(const Epss& value) { m_epssHasBeenSet = true; m_epss = value; }
    inline void SetEpss(Epss&& value) { m_epssHasBeenSet = true; m_epss = std::move(value); }
    inline Vulnerability& WithEpss(const Epss& value) { SetEpss(value); return *this;}
    inline Vulnerability& WithEpss(Epss&& value) { SetEpss(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>An object that contains details on when the exploit was observed.</p>
     */
    inline const ExploitObserved& GetExploitObserved() const{ return m_exploitObserved; }
    inline bool ExploitObservedHasBeenSet() const { return m_exploitObservedHasBeenSet; }
    inline void SetExploitObserved(const ExploitObserved& value) { m_exploitObservedHasBeenSet = true; m_exploitObserved = value; }
    inline void SetExploitObserved(ExploitObserved&& value) { m_exploitObservedHasBeenSet = true; m_exploitObserved = std::move(value); }
    inline Vulnerability& WithExploitObserved(const ExploitObserved& value) { SetExploitObserved(value); return *this;}
    inline Vulnerability& WithExploitObserved(ExploitObserved&& value) { SetExploitObserved(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID for the specific vulnerability.</p>
     */
    inline const Aws::String& GetId() const{ return m_id; }
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }
    inline Vulnerability& WithId(const Aws::String& value) { SetId(value); return *this;}
    inline Vulnerability& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}
    inline Vulnerability& WithId(const char* value) { SetId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Links to various resources with more information on this vulnerability. </p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const{ return m_referenceUrls; }
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }
    inline void SetReferenceUrls(const Aws::Vector<Aws::String>& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = value; }
    inline void SetReferenceUrls(Aws::Vector<Aws::String>&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::move(value); }
    inline Vulnerability& WithReferenceUrls(const Aws::Vector<Aws::String>& value) { SetReferenceUrls(value); return *this;}
    inline Vulnerability& WithReferenceUrls(Aws::Vector<Aws::String>&& value) { SetReferenceUrls(std::move(value)); return *this;}
    inline Vulnerability& AddReferenceUrls(const Aws::String& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }
    inline Vulnerability& AddReferenceUrls(Aws::String&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(std::move(value)); return *this; }
    inline Vulnerability& AddReferenceUrls(const char* value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>A list of related vulnerabilities.</p>
     */
    inline const Aws::Vector<Aws::String>& GetRelatedVulnerabilities() const{ return m_relatedVulnerabilities; }
    inline bool RelatedVulnerabilitiesHasBeenSet() const { return m_relatedVulnerabilitiesHasBeenSet; }
    inline void SetRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = value; }
    inline void SetRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = std::move(value); }
    inline Vulnerability& WithRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { SetRelatedVulnerabilities(value); return *this;}
    inline Vulnerability& WithRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { SetRelatedVulnerabilities(std::move(value)); return *this;}
    inline Vulnerability& AddRelatedVulnerabilities(const Aws::String& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }
    inline Vulnerability& AddRelatedVulnerabilities(Aws::String&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(std::move(value)); return *this; }
    inline Vulnerability& AddRelatedVulnerabilities(const char* value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The source of the vulnerability information. Possible results are
     * <code>RHEL</code>, <code>AMAZON_CVE</code>, <code>DEBIAN</code> or
     * <code>NVD</code>.</p>
     */
    inline const VulnerabilitySource& GetSource() const{ return m_source; }
    inline bool SourceHasBeenSet() const { return m_sourceHasBeenSet; }
    inline void SetSource(const VulnerabilitySource& value) { m_sourceHasBeenSet = true; m_source = value; }
    inline void SetSource(VulnerabilitySource&& value) { m_sourceHasBeenSet = true; m_source = std::move(value); }
    inline Vulnerability& WithSource(const VulnerabilitySource& value) { SetSource(value); return *this;}
    inline Vulnerability& WithSource(VulnerabilitySource&& value) { SetSource(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A link to the official source material for this vulnerability.</p>
     */
    inline const Aws::String& GetSourceUrl() const{ return m_sourceUrl; }
    inline bool SourceUrlHasBeenSet() const { return m_sourceUrlHasBeenSet; }
    inline void SetSourceUrl(const Aws::String& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl = value; }
    inline void SetSourceUrl(Aws::String&& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl = std::move(value); }
    inline void SetSourceUrl(const char* value) { m_sourceUrlHasBeenSet = true; m_sourceUrl.assign(value); }
    inline Vulnerability& WithSourceUrl(const Aws::String& value) { SetSourceUrl(value); return *this;}
    inline Vulnerability& WithSourceUrl(Aws::String&& value) { SetSourceUrl(std::move(value)); return *this;}
    inline Vulnerability& WithSourceUrl(const char* value) { SetSourceUrl(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date and time when the vendor created this vulnerability.</p>
     */
    inline const Aws::Utils::DateTime& GetVendorCreatedAt() const{ return m_vendorCreatedAt; }
    inline bool VendorCreatedAtHasBeenSet() const { return m_vendorCreatedAtHasBeenSet; }
    inline void SetVendorCreatedAt(const Aws::Utils::DateTime& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = value; }
    inline void SetVendorCreatedAt(Aws::Utils::DateTime&& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = std::move(value); }
    inline Vulnerability& WithVendorCreatedAt(const Aws::Utils::DateTime& value) { SetVendorCreatedAt(value); return *this;}
    inline Vulnerability& WithVendorCreatedAt(Aws::Utils::DateTime&& value) { SetVendorCreatedAt(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The severity assigned by the vendor.</p>
     */
    inline const Aws::String& GetVendorSeverity() const{ return m_vendorSeverity; }
    inline bool VendorSeverityHasBeenSet() const { return m_vendorSeverityHasBeenSet; }
    inline void SetVendorSeverity(const Aws::String& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = value; }
    inline void SetVendorSeverity(Aws::String&& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = std::move(value); }
    inline void SetVendorSeverity(const char* value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity.assign(value); }
    inline Vulnerability& WithVendorSeverity(const Aws::String& value) { SetVendorSeverity(value); return *this;}
    inline Vulnerability& WithVendorSeverity(Aws::String&& value) { SetVendorSeverity(std::move(value)); return *this;}
    inline Vulnerability& WithVendorSeverity(const char* value) { SetVendorSeverity(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date and time when the vendor last updated this vulnerability.</p>
     */
    inline const Aws::Utils::DateTime& GetVendorUpdatedAt() const{ return m_vendorUpdatedAt; }
    inline bool VendorUpdatedAtHasBeenSet() const { return m_vendorUpdatedAtHasBeenSet; }
    inline void SetVendorUpdatedAt(const Aws::Utils::DateTime& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = value; }
    inline void SetVendorUpdatedAt(Aws::Utils::DateTime&& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = std::move(value); }
    inline Vulnerability& WithVendorUpdatedAt(const Aws::Utils::DateTime& value) { SetVendorUpdatedAt(value); return *this;}
    inline Vulnerability& WithVendorUpdatedAt(Aws::Utils::DateTime&& value) { SetVendorUpdatedAt(std::move(value)); return *this;}
    ///@}
  private:

    AtigData m_atigData;
    bool m_atigDataHasBeenSet = false;

    CisaData m_cisaData;
    bool m_cisaDataHasBeenSet = false;

    Cvss2 m_cvss2;
    bool m_cvss2HasBeenSet = false;

    Cvss3 m_cvss3;
    bool m_cvss3HasBeenSet = false;

    Aws::Vector<Aws::String> m_cwes;
    bool m_cwesHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    Aws::Vector<Aws::String> m_detectionPlatforms;
    bool m_detectionPlatformsHasBeenSet = false;

    Epss m_epss;
    bool m_epssHasBeenSet = false;

    ExploitObserved m_exploitObserved;
    bool m_exploitObservedHasBeenSet = false;

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet = false;

    Aws::Vector<Aws::String> m_relatedVulnerabilities;
    bool m_relatedVulnerabilitiesHasBeenSet = false;

    VulnerabilitySource m_source;
    bool m_sourceHasBeenSet = false;

    Aws::String m_sourceUrl;
    bool m_sourceUrlHasBeenSet = false;

    Aws::Utils::DateTime m_vendorCreatedAt;
    bool m_vendorCreatedAtHasBeenSet = false;

    Aws::String m_vendorSeverity;
    bool m_vendorSeverityHasBeenSet = false;

    Aws::Utils::DateTime m_vendorUpdatedAt;
    bool m_vendorUpdatedAtHasBeenSet = false;
  };

} // namespace Model
} // namespace Inspector2
} // namespace Aws
