﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iot-managed-integrations/IoTManagedIntegrations_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace IoTManagedIntegrations
{
namespace Model
{
  class SendManagedThingCommandResult
  {
  public:
    AWS_IOTMANAGEDINTEGRATIONS_API SendManagedThingCommandResult();
    AWS_IOTMANAGEDINTEGRATIONS_API SendManagedThingCommandResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_IOTMANAGEDINTEGRATIONS_API SendManagedThingCommandResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The trace request identifier. This is specified by the device owner, but will
     * be generated by IoT managed integrations if not provided by the device
     * owner.</p>
     */
    inline const Aws::String& GetTraceId() const{ return m_traceId; }
    inline void SetTraceId(const Aws::String& value) { m_traceId = value; }
    inline void SetTraceId(Aws::String&& value) { m_traceId = std::move(value); }
    inline void SetTraceId(const char* value) { m_traceId.assign(value); }
    inline SendManagedThingCommandResult& WithTraceId(const Aws::String& value) { SetTraceId(value); return *this;}
    inline SendManagedThingCommandResult& WithTraceId(Aws::String&& value) { SetTraceId(std::move(value)); return *this;}
    inline SendManagedThingCommandResult& WithTraceId(const char* value) { SetTraceId(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline SendManagedThingCommandResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline SendManagedThingCommandResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline SendManagedThingCommandResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_traceId;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace IoTManagedIntegrations
} // namespace Aws
