﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace IoT
{
namespace Model
{
  /**
   * <p>The output of the CreateThingType operation.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/iot-2015-05-28/CreateThingTypeResponse">AWS
   * API Reference</a></p>
   */
  class CreateThingTypeResult
  {
  public:
    AWS_IOT_API CreateThingTypeResult();
    AWS_IOT_API CreateThingTypeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_IOT_API CreateThingTypeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The name of the thing type.</p>
     */
    inline const Aws::String& GetThingTypeName() const{ return m_thingTypeName; }
    inline void SetThingTypeName(const Aws::String& value) { m_thingTypeName = value; }
    inline void SetThingTypeName(Aws::String&& value) { m_thingTypeName = std::move(value); }
    inline void SetThingTypeName(const char* value) { m_thingTypeName.assign(value); }
    inline CreateThingTypeResult& WithThingTypeName(const Aws::String& value) { SetThingTypeName(value); return *this;}
    inline CreateThingTypeResult& WithThingTypeName(Aws::String&& value) { SetThingTypeName(std::move(value)); return *this;}
    inline CreateThingTypeResult& WithThingTypeName(const char* value) { SetThingTypeName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the thing type.</p>
     */
    inline const Aws::String& GetThingTypeArn() const{ return m_thingTypeArn; }
    inline void SetThingTypeArn(const Aws::String& value) { m_thingTypeArn = value; }
    inline void SetThingTypeArn(Aws::String&& value) { m_thingTypeArn = std::move(value); }
    inline void SetThingTypeArn(const char* value) { m_thingTypeArn.assign(value); }
    inline CreateThingTypeResult& WithThingTypeArn(const Aws::String& value) { SetThingTypeArn(value); return *this;}
    inline CreateThingTypeResult& WithThingTypeArn(Aws::String&& value) { SetThingTypeArn(std::move(value)); return *this;}
    inline CreateThingTypeResult& WithThingTypeArn(const char* value) { SetThingTypeArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The thing type ID.</p>
     */
    inline const Aws::String& GetThingTypeId() const{ return m_thingTypeId; }
    inline void SetThingTypeId(const Aws::String& value) { m_thingTypeId = value; }
    inline void SetThingTypeId(Aws::String&& value) { m_thingTypeId = std::move(value); }
    inline void SetThingTypeId(const char* value) { m_thingTypeId.assign(value); }
    inline CreateThingTypeResult& WithThingTypeId(const Aws::String& value) { SetThingTypeId(value); return *this;}
    inline CreateThingTypeResult& WithThingTypeId(Aws::String&& value) { SetThingTypeId(std::move(value)); return *this;}
    inline CreateThingTypeResult& WithThingTypeId(const char* value) { SetThingTypeId(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline CreateThingTypeResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline CreateThingTypeResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline CreateThingTypeResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_thingTypeName;

    Aws::String m_thingTypeArn;

    Aws::String m_thingTypeId;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace IoT
} // namespace Aws
