﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/model/ProvisioningTemplateVersionSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace IoT
{
namespace Model
{
  class ListProvisioningTemplateVersionsResult
  {
  public:
    AWS_IOT_API ListProvisioningTemplateVersionsResult();
    AWS_IOT_API ListProvisioningTemplateVersionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_IOT_API ListProvisioningTemplateVersionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The list of provisioning template versions.</p>
     */
    inline const Aws::Vector<ProvisioningTemplateVersionSummary>& GetVersions() const{ return m_versions; }
    inline void SetVersions(const Aws::Vector<ProvisioningTemplateVersionSummary>& value) { m_versions = value; }
    inline void SetVersions(Aws::Vector<ProvisioningTemplateVersionSummary>&& value) { m_versions = std::move(value); }
    inline ListProvisioningTemplateVersionsResult& WithVersions(const Aws::Vector<ProvisioningTemplateVersionSummary>& value) { SetVersions(value); return *this;}
    inline ListProvisioningTemplateVersionsResult& WithVersions(Aws::Vector<ProvisioningTemplateVersionSummary>&& value) { SetVersions(std::move(value)); return *this;}
    inline ListProvisioningTemplateVersionsResult& AddVersions(const ProvisioningTemplateVersionSummary& value) { m_versions.push_back(value); return *this; }
    inline ListProvisioningTemplateVersionsResult& AddVersions(ProvisioningTemplateVersionSummary&& value) { m_versions.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A token to retrieve the next set of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListProvisioningTemplateVersionsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListProvisioningTemplateVersionsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListProvisioningTemplateVersionsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListProvisioningTemplateVersionsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListProvisioningTemplateVersionsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListProvisioningTemplateVersionsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<ProvisioningTemplateVersionSummary> m_versions;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace IoT
} // namespace Aws
