﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lakeformation/LakeFormation_EXPORTS.h>
#include <aws/lakeformation/LakeFormationRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace LakeFormation
{
namespace Model
{

  /**
   */
  class GetWorkUnitResultsRequest : public LakeFormationRequest
  {
  public:
    AWS_LAKEFORMATION_API GetWorkUnitResultsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "GetWorkUnitResults"; }

    AWS_LAKEFORMATION_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The ID of the plan query operation for which to get results.</p>
     */
    inline const Aws::String& GetQueryId() const{ return m_queryId; }
    inline bool QueryIdHasBeenSet() const { return m_queryIdHasBeenSet; }
    inline void SetQueryId(const Aws::String& value) { m_queryIdHasBeenSet = true; m_queryId = value; }
    inline void SetQueryId(Aws::String&& value) { m_queryIdHasBeenSet = true; m_queryId = std::move(value); }
    inline void SetQueryId(const char* value) { m_queryIdHasBeenSet = true; m_queryId.assign(value); }
    inline GetWorkUnitResultsRequest& WithQueryId(const Aws::String& value) { SetQueryId(value); return *this;}
    inline GetWorkUnitResultsRequest& WithQueryId(Aws::String&& value) { SetQueryId(std::move(value)); return *this;}
    inline GetWorkUnitResultsRequest& WithQueryId(const char* value) { SetQueryId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The work unit ID for which to get results. Value generated by enumerating
     * <code>WorkUnitIdMin</code> to <code>WorkUnitIdMax</code> (inclusive) from the
     * <code>WorkUnitRange</code> in the output of <code>GetWorkUnits</code>.</p>
     */
    inline long long GetWorkUnitId() const{ return m_workUnitId; }
    inline bool WorkUnitIdHasBeenSet() const { return m_workUnitIdHasBeenSet; }
    inline void SetWorkUnitId(long long value) { m_workUnitIdHasBeenSet = true; m_workUnitId = value; }
    inline GetWorkUnitResultsRequest& WithWorkUnitId(long long value) { SetWorkUnitId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A work token used to query the execution service. Token output from
     * <code>GetWorkUnits</code>.</p>
     */
    inline const Aws::String& GetWorkUnitToken() const{ return m_workUnitToken; }
    inline bool WorkUnitTokenHasBeenSet() const { return m_workUnitTokenHasBeenSet; }
    inline void SetWorkUnitToken(const Aws::String& value) { m_workUnitTokenHasBeenSet = true; m_workUnitToken = value; }
    inline void SetWorkUnitToken(Aws::String&& value) { m_workUnitTokenHasBeenSet = true; m_workUnitToken = std::move(value); }
    inline void SetWorkUnitToken(const char* value) { m_workUnitTokenHasBeenSet = true; m_workUnitToken.assign(value); }
    inline GetWorkUnitResultsRequest& WithWorkUnitToken(const Aws::String& value) { SetWorkUnitToken(value); return *this;}
    inline GetWorkUnitResultsRequest& WithWorkUnitToken(Aws::String&& value) { SetWorkUnitToken(std::move(value)); return *this;}
    inline GetWorkUnitResultsRequest& WithWorkUnitToken(const char* value) { SetWorkUnitToken(value); return *this;}
    ///@}
  private:

    Aws::String m_queryId;
    bool m_queryIdHasBeenSet = false;

    long long m_workUnitId;
    bool m_workUnitIdHasBeenSet = false;

    Aws::String m_workUnitToken;
    bool m_workUnitTokenHasBeenSet = false;
  };

} // namespace Model
} // namespace LakeFormation
} // namespace Aws
