﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/model/ExactResponseFields.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace LexModelsV2
{
namespace Model
{

  /**
   * <p>Contains details about the configuration of the Amazon OpenSearch Service
   * database used for the <code>AMAZON.QnAIntent</code>.</p><p><h3>See Also:</h3>  
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/OpensearchConfiguration">AWS
   * API Reference</a></p>
   */
  class OpensearchConfiguration
  {
  public:
    AWS_LEXMODELSV2_API OpensearchConfiguration();
    AWS_LEXMODELSV2_API OpensearchConfiguration(Aws::Utils::Json::JsonView jsonValue);
    AWS_LEXMODELSV2_API OpensearchConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The endpoint of the Amazon OpenSearch Service domain.</p>
     */
    inline const Aws::String& GetDomainEndpoint() const{ return m_domainEndpoint; }
    inline bool DomainEndpointHasBeenSet() const { return m_domainEndpointHasBeenSet; }
    inline void SetDomainEndpoint(const Aws::String& value) { m_domainEndpointHasBeenSet = true; m_domainEndpoint = value; }
    inline void SetDomainEndpoint(Aws::String&& value) { m_domainEndpointHasBeenSet = true; m_domainEndpoint = std::move(value); }
    inline void SetDomainEndpoint(const char* value) { m_domainEndpointHasBeenSet = true; m_domainEndpoint.assign(value); }
    inline OpensearchConfiguration& WithDomainEndpoint(const Aws::String& value) { SetDomainEndpoint(value); return *this;}
    inline OpensearchConfiguration& WithDomainEndpoint(Aws::String&& value) { SetDomainEndpoint(std::move(value)); return *this;}
    inline OpensearchConfiguration& WithDomainEndpoint(const char* value) { SetDomainEndpoint(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the Amazon OpenSearch Service index.</p>
     */
    inline const Aws::String& GetIndexName() const{ return m_indexName; }
    inline bool IndexNameHasBeenSet() const { return m_indexNameHasBeenSet; }
    inline void SetIndexName(const Aws::String& value) { m_indexNameHasBeenSet = true; m_indexName = value; }
    inline void SetIndexName(Aws::String&& value) { m_indexNameHasBeenSet = true; m_indexName = std::move(value); }
    inline void SetIndexName(const char* value) { m_indexNameHasBeenSet = true; m_indexName.assign(value); }
    inline OpensearchConfiguration& WithIndexName(const Aws::String& value) { SetIndexName(value); return *this;}
    inline OpensearchConfiguration& WithIndexName(Aws::String&& value) { SetIndexName(std::move(value)); return *this;}
    inline OpensearchConfiguration& WithIndexName(const char* value) { SetIndexName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Specifies whether to return an exact response or to return an answer
     * generated by the model using the fields you specify from the database.</p>
     */
    inline bool GetExactResponse() const{ return m_exactResponse; }
    inline bool ExactResponseHasBeenSet() const { return m_exactResponseHasBeenSet; }
    inline void SetExactResponse(bool value) { m_exactResponseHasBeenSet = true; m_exactResponse = value; }
    inline OpensearchConfiguration& WithExactResponse(bool value) { SetExactResponse(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains the names of the fields used for an exact response to the user.</p>
     */
    inline const ExactResponseFields& GetExactResponseFields() const{ return m_exactResponseFields; }
    inline bool ExactResponseFieldsHasBeenSet() const { return m_exactResponseFieldsHasBeenSet; }
    inline void SetExactResponseFields(const ExactResponseFields& value) { m_exactResponseFieldsHasBeenSet = true; m_exactResponseFields = value; }
    inline void SetExactResponseFields(ExactResponseFields&& value) { m_exactResponseFieldsHasBeenSet = true; m_exactResponseFields = std::move(value); }
    inline OpensearchConfiguration& WithExactResponseFields(const ExactResponseFields& value) { SetExactResponseFields(value); return *this;}
    inline OpensearchConfiguration& WithExactResponseFields(ExactResponseFields&& value) { SetExactResponseFields(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains a list of fields from the Amazon OpenSearch Service that the model
     * can use to generate the answer to the query.</p>
     */
    inline const Aws::Vector<Aws::String>& GetIncludeFields() const{ return m_includeFields; }
    inline bool IncludeFieldsHasBeenSet() const { return m_includeFieldsHasBeenSet; }
    inline void SetIncludeFields(const Aws::Vector<Aws::String>& value) { m_includeFieldsHasBeenSet = true; m_includeFields = value; }
    inline void SetIncludeFields(Aws::Vector<Aws::String>&& value) { m_includeFieldsHasBeenSet = true; m_includeFields = std::move(value); }
    inline OpensearchConfiguration& WithIncludeFields(const Aws::Vector<Aws::String>& value) { SetIncludeFields(value); return *this;}
    inline OpensearchConfiguration& WithIncludeFields(Aws::Vector<Aws::String>&& value) { SetIncludeFields(std::move(value)); return *this;}
    inline OpensearchConfiguration& AddIncludeFields(const Aws::String& value) { m_includeFieldsHasBeenSet = true; m_includeFields.push_back(value); return *this; }
    inline OpensearchConfiguration& AddIncludeFields(Aws::String&& value) { m_includeFieldsHasBeenSet = true; m_includeFields.push_back(std::move(value)); return *this; }
    inline OpensearchConfiguration& AddIncludeFields(const char* value) { m_includeFieldsHasBeenSet = true; m_includeFields.push_back(value); return *this; }
    ///@}
  private:

    Aws::String m_domainEndpoint;
    bool m_domainEndpointHasBeenSet = false;

    Aws::String m_indexName;
    bool m_indexNameHasBeenSet = false;

    bool m_exactResponse;
    bool m_exactResponseHasBeenSet = false;

    ExactResponseFields m_exactResponseFields;
    bool m_exactResponseFieldsHasBeenSet = false;

    Aws::Vector<Aws::String> m_includeFields;
    bool m_includeFieldsHasBeenSet = false;
  };

} // namespace Model
} // namespace LexModelsV2
} // namespace Aws
