﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/mediaconnect/MediaConnect_EXPORTS.h>
#include <aws/mediaconnect/model/Offering.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace MediaConnect
{
namespace Model
{
  class DescribeOfferingResult
  {
  public:
    AWS_MEDIACONNECT_API DescribeOfferingResult();
    AWS_MEDIACONNECT_API DescribeOfferingResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_MEDIACONNECT_API DescribeOfferingResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    
    inline const Offering& GetOffering() const{ return m_offering; }
    inline void SetOffering(const Offering& value) { m_offering = value; }
    inline void SetOffering(Offering&& value) { m_offering = std::move(value); }
    inline DescribeOfferingResult& WithOffering(const Offering& value) { SetOffering(value); return *this;}
    inline DescribeOfferingResult& WithOffering(Offering&& value) { SetOffering(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DescribeOfferingResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DescribeOfferingResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DescribeOfferingResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Offering m_offering;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace MediaConnect
} // namespace Aws
