﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/neptunedata/Neptunedata_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace neptunedata
{
namespace Model
{

  /**
   * <p>A structure containing the fast reset token used to initiate a fast
   * reset.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/FastResetToken">AWS
   * API Reference</a></p>
   */
  class FastResetToken
  {
  public:
    AWS_NEPTUNEDATA_API FastResetToken();
    AWS_NEPTUNEDATA_API FastResetToken(Aws::Utils::Json::JsonView jsonValue);
    AWS_NEPTUNEDATA_API FastResetToken& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_NEPTUNEDATA_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>A UUID generated by the database in the <code>initiateDatabaseReset</code>
     * action, and then consumed by the <code>performDatabaseReset</code> to reset the
     * database.</p>
     */
    inline const Aws::String& GetToken() const{ return m_token; }
    inline bool TokenHasBeenSet() const { return m_tokenHasBeenSet; }
    inline void SetToken(const Aws::String& value) { m_tokenHasBeenSet = true; m_token = value; }
    inline void SetToken(Aws::String&& value) { m_tokenHasBeenSet = true; m_token = std::move(value); }
    inline void SetToken(const char* value) { m_tokenHasBeenSet = true; m_token.assign(value); }
    inline FastResetToken& WithToken(const Aws::String& value) { SetToken(value); return *this;}
    inline FastResetToken& WithToken(Aws::String&& value) { SetToken(std::move(value)); return *this;}
    inline FastResetToken& WithToken(const char* value) { SetToken(value); return *this;}
    ///@}
  private:

    Aws::String m_token;
    bool m_tokenHasBeenSet = false;
  };

} // namespace Model
} // namespace neptunedata
} // namespace Aws
