﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/neptunedata/Neptunedata_EXPORTS.h>
#include <aws/neptunedata/NeptunedataRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace neptunedata
{
namespace Model
{

  /**
   */
  class StartMLDataProcessingJobRequest : public NeptunedataRequest
  {
  public:
    AWS_NEPTUNEDATA_API StartMLDataProcessingJobRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "StartMLDataProcessingJob"; }

    AWS_NEPTUNEDATA_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>A unique identifier for the new job. The default is an autogenerated
     * UUID.</p>
     */
    inline const Aws::String& GetId() const{ return m_id; }
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }
    inline StartMLDataProcessingJobRequest& WithId(const Aws::String& value) { SetId(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithId(const char* value) { SetId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job ID of a completed data processing job run on an earlier version of
     * the data.</p>
     */
    inline const Aws::String& GetPreviousDataProcessingJobId() const{ return m_previousDataProcessingJobId; }
    inline bool PreviousDataProcessingJobIdHasBeenSet() const { return m_previousDataProcessingJobIdHasBeenSet; }
    inline void SetPreviousDataProcessingJobId(const Aws::String& value) { m_previousDataProcessingJobIdHasBeenSet = true; m_previousDataProcessingJobId = value; }
    inline void SetPreviousDataProcessingJobId(Aws::String&& value) { m_previousDataProcessingJobIdHasBeenSet = true; m_previousDataProcessingJobId = std::move(value); }
    inline void SetPreviousDataProcessingJobId(const char* value) { m_previousDataProcessingJobIdHasBeenSet = true; m_previousDataProcessingJobId.assign(value); }
    inline StartMLDataProcessingJobRequest& WithPreviousDataProcessingJobId(const Aws::String& value) { SetPreviousDataProcessingJobId(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithPreviousDataProcessingJobId(Aws::String&& value) { SetPreviousDataProcessingJobId(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithPreviousDataProcessingJobId(const char* value) { SetPreviousDataProcessingJobId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The URI of the Amazon S3 location where you want SageMaker to download the
     * data needed to run the data processing job.</p>
     */
    inline const Aws::String& GetInputDataS3Location() const{ return m_inputDataS3Location; }
    inline bool InputDataS3LocationHasBeenSet() const { return m_inputDataS3LocationHasBeenSet; }
    inline void SetInputDataS3Location(const Aws::String& value) { m_inputDataS3LocationHasBeenSet = true; m_inputDataS3Location = value; }
    inline void SetInputDataS3Location(Aws::String&& value) { m_inputDataS3LocationHasBeenSet = true; m_inputDataS3Location = std::move(value); }
    inline void SetInputDataS3Location(const char* value) { m_inputDataS3LocationHasBeenSet = true; m_inputDataS3Location.assign(value); }
    inline StartMLDataProcessingJobRequest& WithInputDataS3Location(const Aws::String& value) { SetInputDataS3Location(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithInputDataS3Location(Aws::String&& value) { SetInputDataS3Location(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithInputDataS3Location(const char* value) { SetInputDataS3Location(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The URI of the Amazon S3 location where you want SageMaker to save the
     * results of a data processing job.</p>
     */
    inline const Aws::String& GetProcessedDataS3Location() const{ return m_processedDataS3Location; }
    inline bool ProcessedDataS3LocationHasBeenSet() const { return m_processedDataS3LocationHasBeenSet; }
    inline void SetProcessedDataS3Location(const Aws::String& value) { m_processedDataS3LocationHasBeenSet = true; m_processedDataS3Location = value; }
    inline void SetProcessedDataS3Location(Aws::String&& value) { m_processedDataS3LocationHasBeenSet = true; m_processedDataS3Location = std::move(value); }
    inline void SetProcessedDataS3Location(const char* value) { m_processedDataS3LocationHasBeenSet = true; m_processedDataS3Location.assign(value); }
    inline StartMLDataProcessingJobRequest& WithProcessedDataS3Location(const Aws::String& value) { SetProcessedDataS3Location(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithProcessedDataS3Location(Aws::String&& value) { SetProcessedDataS3Location(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithProcessedDataS3Location(const char* value) { SetProcessedDataS3Location(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ARN of an IAM role for SageMaker execution. This must be listed in your
     * DB cluster parameter group or an error will occur.</p>
     */
    inline const Aws::String& GetSagemakerIamRoleArn() const{ return m_sagemakerIamRoleArn; }
    inline bool SagemakerIamRoleArnHasBeenSet() const { return m_sagemakerIamRoleArnHasBeenSet; }
    inline void SetSagemakerIamRoleArn(const Aws::String& value) { m_sagemakerIamRoleArnHasBeenSet = true; m_sagemakerIamRoleArn = value; }
    inline void SetSagemakerIamRoleArn(Aws::String&& value) { m_sagemakerIamRoleArnHasBeenSet = true; m_sagemakerIamRoleArn = std::move(value); }
    inline void SetSagemakerIamRoleArn(const char* value) { m_sagemakerIamRoleArnHasBeenSet = true; m_sagemakerIamRoleArn.assign(value); }
    inline StartMLDataProcessingJobRequest& WithSagemakerIamRoleArn(const Aws::String& value) { SetSagemakerIamRoleArn(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithSagemakerIamRoleArn(Aws::String&& value) { SetSagemakerIamRoleArn(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithSagemakerIamRoleArn(const char* value) { SetSagemakerIamRoleArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to
     * perform tasks on your behalf. This must be listed in your DB cluster parameter
     * group or an error will occur.</p>
     */
    inline const Aws::String& GetNeptuneIamRoleArn() const{ return m_neptuneIamRoleArn; }
    inline bool NeptuneIamRoleArnHasBeenSet() const { return m_neptuneIamRoleArnHasBeenSet; }
    inline void SetNeptuneIamRoleArn(const Aws::String& value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn = value; }
    inline void SetNeptuneIamRoleArn(Aws::String&& value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn = std::move(value); }
    inline void SetNeptuneIamRoleArn(const char* value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn.assign(value); }
    inline StartMLDataProcessingJobRequest& WithNeptuneIamRoleArn(const Aws::String& value) { SetNeptuneIamRoleArn(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithNeptuneIamRoleArn(Aws::String&& value) { SetNeptuneIamRoleArn(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithNeptuneIamRoleArn(const char* value) { SetNeptuneIamRoleArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of ML instance used during data processing. Its memory should be
     * large enough to hold the processed dataset. The default is the smallest ml.r5
     * type whose memory is ten times larger than the size of the exported graph data
     * on disk.</p>
     */
    inline const Aws::String& GetProcessingInstanceType() const{ return m_processingInstanceType; }
    inline bool ProcessingInstanceTypeHasBeenSet() const { return m_processingInstanceTypeHasBeenSet; }
    inline void SetProcessingInstanceType(const Aws::String& value) { m_processingInstanceTypeHasBeenSet = true; m_processingInstanceType = value; }
    inline void SetProcessingInstanceType(Aws::String&& value) { m_processingInstanceTypeHasBeenSet = true; m_processingInstanceType = std::move(value); }
    inline void SetProcessingInstanceType(const char* value) { m_processingInstanceTypeHasBeenSet = true; m_processingInstanceType.assign(value); }
    inline StartMLDataProcessingJobRequest& WithProcessingInstanceType(const Aws::String& value) { SetProcessingInstanceType(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithProcessingInstanceType(Aws::String&& value) { SetProcessingInstanceType(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithProcessingInstanceType(const char* value) { SetProcessingInstanceType(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The disk volume size of the processing instance. Both input data and
     * processed data are stored on disk, so the volume size must be large enough to
     * hold both data sets. The default is 0. If not specified or 0, Neptune ML chooses
     * the volume size automatically based on the data size.</p>
     */
    inline int GetProcessingInstanceVolumeSizeInGB() const{ return m_processingInstanceVolumeSizeInGB; }
    inline bool ProcessingInstanceVolumeSizeInGBHasBeenSet() const { return m_processingInstanceVolumeSizeInGBHasBeenSet; }
    inline void SetProcessingInstanceVolumeSizeInGB(int value) { m_processingInstanceVolumeSizeInGBHasBeenSet = true; m_processingInstanceVolumeSizeInGB = value; }
    inline StartMLDataProcessingJobRequest& WithProcessingInstanceVolumeSizeInGB(int value) { SetProcessingInstanceVolumeSizeInGB(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Timeout in seconds for the data processing job. The default is 86,400 (1
     * day).</p>
     */
    inline int GetProcessingTimeOutInSeconds() const{ return m_processingTimeOutInSeconds; }
    inline bool ProcessingTimeOutInSecondsHasBeenSet() const { return m_processingTimeOutInSecondsHasBeenSet; }
    inline void SetProcessingTimeOutInSeconds(int value) { m_processingTimeOutInSecondsHasBeenSet = true; m_processingTimeOutInSeconds = value; }
    inline StartMLDataProcessingJobRequest& WithProcessingTimeOutInSeconds(int value) { SetProcessingTimeOutInSeconds(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>One of the two model types that Neptune ML currently supports: heterogeneous
     * graph models (<code>heterogeneous</code>), and knowledge graph
     * (<code>kge</code>). The default is none. If not specified, Neptune ML chooses
     * the model type automatically based on the data.</p>
     */
    inline const Aws::String& GetModelType() const{ return m_modelType; }
    inline bool ModelTypeHasBeenSet() const { return m_modelTypeHasBeenSet; }
    inline void SetModelType(const Aws::String& value) { m_modelTypeHasBeenSet = true; m_modelType = value; }
    inline void SetModelType(Aws::String&& value) { m_modelTypeHasBeenSet = true; m_modelType = std::move(value); }
    inline void SetModelType(const char* value) { m_modelTypeHasBeenSet = true; m_modelType.assign(value); }
    inline StartMLDataProcessingJobRequest& WithModelType(const Aws::String& value) { SetModelType(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithModelType(Aws::String&& value) { SetModelType(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithModelType(const char* value) { SetModelType(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A data specification file that describes how to load the exported graph data
     * for training. The file is automatically generated by the Neptune export toolkit.
     * The default is <code>training-data-configuration.json</code>.</p>
     */
    inline const Aws::String& GetConfigFileName() const{ return m_configFileName; }
    inline bool ConfigFileNameHasBeenSet() const { return m_configFileNameHasBeenSet; }
    inline void SetConfigFileName(const Aws::String& value) { m_configFileNameHasBeenSet = true; m_configFileName = value; }
    inline void SetConfigFileName(Aws::String&& value) { m_configFileNameHasBeenSet = true; m_configFileName = std::move(value); }
    inline void SetConfigFileName(const char* value) { m_configFileNameHasBeenSet = true; m_configFileName.assign(value); }
    inline StartMLDataProcessingJobRequest& WithConfigFileName(const Aws::String& value) { SetConfigFileName(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithConfigFileName(Aws::String&& value) { SetConfigFileName(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithConfigFileName(const char* value) { SetConfigFileName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The IDs of the subnets in the Neptune VPC. The default is None.</p>
     */
    inline const Aws::Vector<Aws::String>& GetSubnets() const{ return m_subnets; }
    inline bool SubnetsHasBeenSet() const { return m_subnetsHasBeenSet; }
    inline void SetSubnets(const Aws::Vector<Aws::String>& value) { m_subnetsHasBeenSet = true; m_subnets = value; }
    inline void SetSubnets(Aws::Vector<Aws::String>&& value) { m_subnetsHasBeenSet = true; m_subnets = std::move(value); }
    inline StartMLDataProcessingJobRequest& WithSubnets(const Aws::Vector<Aws::String>& value) { SetSubnets(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithSubnets(Aws::Vector<Aws::String>&& value) { SetSubnets(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& AddSubnets(const Aws::String& value) { m_subnetsHasBeenSet = true; m_subnets.push_back(value); return *this; }
    inline StartMLDataProcessingJobRequest& AddSubnets(Aws::String&& value) { m_subnetsHasBeenSet = true; m_subnets.push_back(std::move(value)); return *this; }
    inline StartMLDataProcessingJobRequest& AddSubnets(const char* value) { m_subnetsHasBeenSet = true; m_subnets.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The VPC security group IDs. The default is None.</p>
     */
    inline const Aws::Vector<Aws::String>& GetSecurityGroupIds() const{ return m_securityGroupIds; }
    inline bool SecurityGroupIdsHasBeenSet() const { return m_securityGroupIdsHasBeenSet; }
    inline void SetSecurityGroupIds(const Aws::Vector<Aws::String>& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds = value; }
    inline void SetSecurityGroupIds(Aws::Vector<Aws::String>&& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds = std::move(value); }
    inline StartMLDataProcessingJobRequest& WithSecurityGroupIds(const Aws::Vector<Aws::String>& value) { SetSecurityGroupIds(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithSecurityGroupIds(Aws::Vector<Aws::String>&& value) { SetSecurityGroupIds(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& AddSecurityGroupIds(const Aws::String& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.push_back(value); return *this; }
    inline StartMLDataProcessingJobRequest& AddSecurityGroupIds(Aws::String&& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.push_back(std::move(value)); return *this; }
    inline StartMLDataProcessingJobRequest& AddSecurityGroupIds(const char* value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to
     * encrypt data on the storage volume attached to the ML compute instances that run
     * the training job. The default is None.</p>
     */
    inline const Aws::String& GetVolumeEncryptionKMSKey() const{ return m_volumeEncryptionKMSKey; }
    inline bool VolumeEncryptionKMSKeyHasBeenSet() const { return m_volumeEncryptionKMSKeyHasBeenSet; }
    inline void SetVolumeEncryptionKMSKey(const Aws::String& value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey = value; }
    inline void SetVolumeEncryptionKMSKey(Aws::String&& value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey = std::move(value); }
    inline void SetVolumeEncryptionKMSKey(const char* value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey.assign(value); }
    inline StartMLDataProcessingJobRequest& WithVolumeEncryptionKMSKey(const Aws::String& value) { SetVolumeEncryptionKMSKey(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithVolumeEncryptionKMSKey(Aws::String&& value) { SetVolumeEncryptionKMSKey(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithVolumeEncryptionKMSKey(const char* value) { SetVolumeEncryptionKMSKey(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to
     * encrypt the output of the processing job. The default is none.</p>
     */
    inline const Aws::String& GetS3OutputEncryptionKMSKey() const{ return m_s3OutputEncryptionKMSKey; }
    inline bool S3OutputEncryptionKMSKeyHasBeenSet() const { return m_s3OutputEncryptionKMSKeyHasBeenSet; }
    inline void SetS3OutputEncryptionKMSKey(const Aws::String& value) { m_s3OutputEncryptionKMSKeyHasBeenSet = true; m_s3OutputEncryptionKMSKey = value; }
    inline void SetS3OutputEncryptionKMSKey(Aws::String&& value) { m_s3OutputEncryptionKMSKeyHasBeenSet = true; m_s3OutputEncryptionKMSKey = std::move(value); }
    inline void SetS3OutputEncryptionKMSKey(const char* value) { m_s3OutputEncryptionKMSKeyHasBeenSet = true; m_s3OutputEncryptionKMSKey.assign(value); }
    inline StartMLDataProcessingJobRequest& WithS3OutputEncryptionKMSKey(const Aws::String& value) { SetS3OutputEncryptionKMSKey(value); return *this;}
    inline StartMLDataProcessingJobRequest& WithS3OutputEncryptionKMSKey(Aws::String&& value) { SetS3OutputEncryptionKMSKey(std::move(value)); return *this;}
    inline StartMLDataProcessingJobRequest& WithS3OutputEncryptionKMSKey(const char* value) { SetS3OutputEncryptionKMSKey(value); return *this;}
    ///@}
  private:

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::String m_previousDataProcessingJobId;
    bool m_previousDataProcessingJobIdHasBeenSet = false;

    Aws::String m_inputDataS3Location;
    bool m_inputDataS3LocationHasBeenSet = false;

    Aws::String m_processedDataS3Location;
    bool m_processedDataS3LocationHasBeenSet = false;

    Aws::String m_sagemakerIamRoleArn;
    bool m_sagemakerIamRoleArnHasBeenSet = false;

    Aws::String m_neptuneIamRoleArn;
    bool m_neptuneIamRoleArnHasBeenSet = false;

    Aws::String m_processingInstanceType;
    bool m_processingInstanceTypeHasBeenSet = false;

    int m_processingInstanceVolumeSizeInGB;
    bool m_processingInstanceVolumeSizeInGBHasBeenSet = false;

    int m_processingTimeOutInSeconds;
    bool m_processingTimeOutInSecondsHasBeenSet = false;

    Aws::String m_modelType;
    bool m_modelTypeHasBeenSet = false;

    Aws::String m_configFileName;
    bool m_configFileNameHasBeenSet = false;

    Aws::Vector<Aws::String> m_subnets;
    bool m_subnetsHasBeenSet = false;

    Aws::Vector<Aws::String> m_securityGroupIds;
    bool m_securityGroupIdsHasBeenSet = false;

    Aws::String m_volumeEncryptionKMSKey;
    bool m_volumeEncryptionKMSKeyHasBeenSet = false;

    Aws::String m_s3OutputEncryptionKMSKey;
    bool m_s3OutputEncryptionKMSKeyHasBeenSet = false;
  };

} // namespace Model
} // namespace neptunedata
} // namespace Aws
