﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/neptunedata/Neptunedata_EXPORTS.h>
#include <aws/neptunedata/NeptunedataRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/neptunedata/model/CustomModelTrainingParameters.h>
#include <utility>

namespace Aws
{
namespace neptunedata
{
namespace Model
{

  /**
   */
  class StartMLModelTrainingJobRequest : public NeptunedataRequest
  {
  public:
    AWS_NEPTUNEDATA_API StartMLModelTrainingJobRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "StartMLModelTrainingJob"; }

    AWS_NEPTUNEDATA_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>A unique identifier for the new job. The default is An autogenerated
     * UUID.</p>
     */
    inline const Aws::String& GetId() const{ return m_id; }
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }
    inline StartMLModelTrainingJobRequest& WithId(const Aws::String& value) { SetId(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithId(const char* value) { SetId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job ID of a completed model-training job that you want to update
     * incrementally based on updated data.</p>
     */
    inline const Aws::String& GetPreviousModelTrainingJobId() const{ return m_previousModelTrainingJobId; }
    inline bool PreviousModelTrainingJobIdHasBeenSet() const { return m_previousModelTrainingJobIdHasBeenSet; }
    inline void SetPreviousModelTrainingJobId(const Aws::String& value) { m_previousModelTrainingJobIdHasBeenSet = true; m_previousModelTrainingJobId = value; }
    inline void SetPreviousModelTrainingJobId(Aws::String&& value) { m_previousModelTrainingJobIdHasBeenSet = true; m_previousModelTrainingJobId = std::move(value); }
    inline void SetPreviousModelTrainingJobId(const char* value) { m_previousModelTrainingJobIdHasBeenSet = true; m_previousModelTrainingJobId.assign(value); }
    inline StartMLModelTrainingJobRequest& WithPreviousModelTrainingJobId(const Aws::String& value) { SetPreviousModelTrainingJobId(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithPreviousModelTrainingJobId(Aws::String&& value) { SetPreviousModelTrainingJobId(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithPreviousModelTrainingJobId(const char* value) { SetPreviousModelTrainingJobId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job ID of the completed data-processing job that has created the data
     * that the training will work with.</p>
     */
    inline const Aws::String& GetDataProcessingJobId() const{ return m_dataProcessingJobId; }
    inline bool DataProcessingJobIdHasBeenSet() const { return m_dataProcessingJobIdHasBeenSet; }
    inline void SetDataProcessingJobId(const Aws::String& value) { m_dataProcessingJobIdHasBeenSet = true; m_dataProcessingJobId = value; }
    inline void SetDataProcessingJobId(Aws::String&& value) { m_dataProcessingJobIdHasBeenSet = true; m_dataProcessingJobId = std::move(value); }
    inline void SetDataProcessingJobId(const char* value) { m_dataProcessingJobIdHasBeenSet = true; m_dataProcessingJobId.assign(value); }
    inline StartMLModelTrainingJobRequest& WithDataProcessingJobId(const Aws::String& value) { SetDataProcessingJobId(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithDataProcessingJobId(Aws::String&& value) { SetDataProcessingJobId(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithDataProcessingJobId(const char* value) { SetDataProcessingJobId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The location in Amazon S3 where the model artifacts are to be stored.</p>
     */
    inline const Aws::String& GetTrainModelS3Location() const{ return m_trainModelS3Location; }
    inline bool TrainModelS3LocationHasBeenSet() const { return m_trainModelS3LocationHasBeenSet; }
    inline void SetTrainModelS3Location(const Aws::String& value) { m_trainModelS3LocationHasBeenSet = true; m_trainModelS3Location = value; }
    inline void SetTrainModelS3Location(Aws::String&& value) { m_trainModelS3LocationHasBeenSet = true; m_trainModelS3Location = std::move(value); }
    inline void SetTrainModelS3Location(const char* value) { m_trainModelS3LocationHasBeenSet = true; m_trainModelS3Location.assign(value); }
    inline StartMLModelTrainingJobRequest& WithTrainModelS3Location(const Aws::String& value) { SetTrainModelS3Location(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithTrainModelS3Location(Aws::String&& value) { SetTrainModelS3Location(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithTrainModelS3Location(const char* value) { SetTrainModelS3Location(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ARN of an IAM role for SageMaker execution.This must be listed in your DB
     * cluster parameter group or an error will occur.</p>
     */
    inline const Aws::String& GetSagemakerIamRoleArn() const{ return m_sagemakerIamRoleArn; }
    inline bool SagemakerIamRoleArnHasBeenSet() const { return m_sagemakerIamRoleArnHasBeenSet; }
    inline void SetSagemakerIamRoleArn(const Aws::String& value) { m_sagemakerIamRoleArnHasBeenSet = true; m_sagemakerIamRoleArn = value; }
    inline void SetSagemakerIamRoleArn(Aws::String&& value) { m_sagemakerIamRoleArnHasBeenSet = true; m_sagemakerIamRoleArn = std::move(value); }
    inline void SetSagemakerIamRoleArn(const char* value) { m_sagemakerIamRoleArnHasBeenSet = true; m_sagemakerIamRoleArn.assign(value); }
    inline StartMLModelTrainingJobRequest& WithSagemakerIamRoleArn(const Aws::String& value) { SetSagemakerIamRoleArn(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithSagemakerIamRoleArn(Aws::String&& value) { SetSagemakerIamRoleArn(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithSagemakerIamRoleArn(const char* value) { SetSagemakerIamRoleArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon
     * S3 resources. This must be listed in your DB cluster parameter group or an error
     * will occur.</p>
     */
    inline const Aws::String& GetNeptuneIamRoleArn() const{ return m_neptuneIamRoleArn; }
    inline bool NeptuneIamRoleArnHasBeenSet() const { return m_neptuneIamRoleArnHasBeenSet; }
    inline void SetNeptuneIamRoleArn(const Aws::String& value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn = value; }
    inline void SetNeptuneIamRoleArn(Aws::String&& value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn = std::move(value); }
    inline void SetNeptuneIamRoleArn(const char* value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn.assign(value); }
    inline StartMLModelTrainingJobRequest& WithNeptuneIamRoleArn(const Aws::String& value) { SetNeptuneIamRoleArn(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithNeptuneIamRoleArn(Aws::String&& value) { SetNeptuneIamRoleArn(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithNeptuneIamRoleArn(const char* value) { SetNeptuneIamRoleArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of ML instance used in preparing and managing training of ML models.
     * This is a CPU instance chosen based on memory requirements for processing the
     * training data and model.</p>
     */
    inline const Aws::String& GetBaseProcessingInstanceType() const{ return m_baseProcessingInstanceType; }
    inline bool BaseProcessingInstanceTypeHasBeenSet() const { return m_baseProcessingInstanceTypeHasBeenSet; }
    inline void SetBaseProcessingInstanceType(const Aws::String& value) { m_baseProcessingInstanceTypeHasBeenSet = true; m_baseProcessingInstanceType = value; }
    inline void SetBaseProcessingInstanceType(Aws::String&& value) { m_baseProcessingInstanceTypeHasBeenSet = true; m_baseProcessingInstanceType = std::move(value); }
    inline void SetBaseProcessingInstanceType(const char* value) { m_baseProcessingInstanceTypeHasBeenSet = true; m_baseProcessingInstanceType.assign(value); }
    inline StartMLModelTrainingJobRequest& WithBaseProcessingInstanceType(const Aws::String& value) { SetBaseProcessingInstanceType(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithBaseProcessingInstanceType(Aws::String&& value) { SetBaseProcessingInstanceType(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithBaseProcessingInstanceType(const char* value) { SetBaseProcessingInstanceType(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of ML instance used for model training. All Neptune ML models
     * support CPU, GPU, and multiGPU training. The default is
     * <code>ml.p3.2xlarge</code>. Choosing the right instance type for training
     * depends on the task type, graph size, and your budget.</p>
     */
    inline const Aws::String& GetTrainingInstanceType() const{ return m_trainingInstanceType; }
    inline bool TrainingInstanceTypeHasBeenSet() const { return m_trainingInstanceTypeHasBeenSet; }
    inline void SetTrainingInstanceType(const Aws::String& value) { m_trainingInstanceTypeHasBeenSet = true; m_trainingInstanceType = value; }
    inline void SetTrainingInstanceType(Aws::String&& value) { m_trainingInstanceTypeHasBeenSet = true; m_trainingInstanceType = std::move(value); }
    inline void SetTrainingInstanceType(const char* value) { m_trainingInstanceTypeHasBeenSet = true; m_trainingInstanceType.assign(value); }
    inline StartMLModelTrainingJobRequest& WithTrainingInstanceType(const Aws::String& value) { SetTrainingInstanceType(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithTrainingInstanceType(Aws::String&& value) { SetTrainingInstanceType(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithTrainingInstanceType(const char* value) { SetTrainingInstanceType(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The disk volume size of the training instance. Both input data and the output
     * model are stored on disk, so the volume size must be large enough to hold both
     * data sets. The default is 0. If not specified or 0, Neptune ML selects a disk
     * volume size based on the recommendation generated in the data processing
     * step.</p>
     */
    inline int GetTrainingInstanceVolumeSizeInGB() const{ return m_trainingInstanceVolumeSizeInGB; }
    inline bool TrainingInstanceVolumeSizeInGBHasBeenSet() const { return m_trainingInstanceVolumeSizeInGBHasBeenSet; }
    inline void SetTrainingInstanceVolumeSizeInGB(int value) { m_trainingInstanceVolumeSizeInGBHasBeenSet = true; m_trainingInstanceVolumeSizeInGB = value; }
    inline StartMLModelTrainingJobRequest& WithTrainingInstanceVolumeSizeInGB(int value) { SetTrainingInstanceVolumeSizeInGB(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Timeout in seconds for the training job. The default is 86,400 (1 day).</p>
     */
    inline int GetTrainingTimeOutInSeconds() const{ return m_trainingTimeOutInSeconds; }
    inline bool TrainingTimeOutInSecondsHasBeenSet() const { return m_trainingTimeOutInSecondsHasBeenSet; }
    inline void SetTrainingTimeOutInSeconds(int value) { m_trainingTimeOutInSecondsHasBeenSet = true; m_trainingTimeOutInSeconds = value; }
    inline StartMLModelTrainingJobRequest& WithTrainingTimeOutInSeconds(int value) { SetTrainingTimeOutInSeconds(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Maximum total number of training jobs to start for the hyperparameter tuning
     * job. The default is 2. Neptune ML automatically tunes the hyperparameters of the
     * machine learning model. To obtain a model that performs well, use at least 10
     * jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10). In
     * general, the more tuning runs, the better the results.</p>
     */
    inline int GetMaxHPONumberOfTrainingJobs() const{ return m_maxHPONumberOfTrainingJobs; }
    inline bool MaxHPONumberOfTrainingJobsHasBeenSet() const { return m_maxHPONumberOfTrainingJobsHasBeenSet; }
    inline void SetMaxHPONumberOfTrainingJobs(int value) { m_maxHPONumberOfTrainingJobsHasBeenSet = true; m_maxHPONumberOfTrainingJobs = value; }
    inline StartMLModelTrainingJobRequest& WithMaxHPONumberOfTrainingJobs(int value) { SetMaxHPONumberOfTrainingJobs(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Maximum number of parallel training jobs to start for the hyperparameter
     * tuning job. The default is 2. The number of parallel jobs you can run is limited
     * by the available resources on your training instance.</p>
     */
    inline int GetMaxHPOParallelTrainingJobs() const{ return m_maxHPOParallelTrainingJobs; }
    inline bool MaxHPOParallelTrainingJobsHasBeenSet() const { return m_maxHPOParallelTrainingJobsHasBeenSet; }
    inline void SetMaxHPOParallelTrainingJobs(int value) { m_maxHPOParallelTrainingJobsHasBeenSet = true; m_maxHPOParallelTrainingJobs = value; }
    inline StartMLModelTrainingJobRequest& WithMaxHPOParallelTrainingJobs(int value) { SetMaxHPOParallelTrainingJobs(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The IDs of the subnets in the Neptune VPC. The default is None.</p>
     */
    inline const Aws::Vector<Aws::String>& GetSubnets() const{ return m_subnets; }
    inline bool SubnetsHasBeenSet() const { return m_subnetsHasBeenSet; }
    inline void SetSubnets(const Aws::Vector<Aws::String>& value) { m_subnetsHasBeenSet = true; m_subnets = value; }
    inline void SetSubnets(Aws::Vector<Aws::String>&& value) { m_subnetsHasBeenSet = true; m_subnets = std::move(value); }
    inline StartMLModelTrainingJobRequest& WithSubnets(const Aws::Vector<Aws::String>& value) { SetSubnets(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithSubnets(Aws::Vector<Aws::String>&& value) { SetSubnets(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& AddSubnets(const Aws::String& value) { m_subnetsHasBeenSet = true; m_subnets.push_back(value); return *this; }
    inline StartMLModelTrainingJobRequest& AddSubnets(Aws::String&& value) { m_subnetsHasBeenSet = true; m_subnets.push_back(std::move(value)); return *this; }
    inline StartMLModelTrainingJobRequest& AddSubnets(const char* value) { m_subnetsHasBeenSet = true; m_subnets.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The VPC security group IDs. The default is None.</p>
     */
    inline const Aws::Vector<Aws::String>& GetSecurityGroupIds() const{ return m_securityGroupIds; }
    inline bool SecurityGroupIdsHasBeenSet() const { return m_securityGroupIdsHasBeenSet; }
    inline void SetSecurityGroupIds(const Aws::Vector<Aws::String>& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds = value; }
    inline void SetSecurityGroupIds(Aws::Vector<Aws::String>&& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds = std::move(value); }
    inline StartMLModelTrainingJobRequest& WithSecurityGroupIds(const Aws::Vector<Aws::String>& value) { SetSecurityGroupIds(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithSecurityGroupIds(Aws::Vector<Aws::String>&& value) { SetSecurityGroupIds(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& AddSecurityGroupIds(const Aws::String& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.push_back(value); return *this; }
    inline StartMLModelTrainingJobRequest& AddSecurityGroupIds(Aws::String&& value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.push_back(std::move(value)); return *this; }
    inline StartMLModelTrainingJobRequest& AddSecurityGroupIds(const char* value) { m_securityGroupIdsHasBeenSet = true; m_securityGroupIds.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt
     * data on the storage volume attached to the ML compute instances that run the
     * training job. The default is None.</p>
     */
    inline const Aws::String& GetVolumeEncryptionKMSKey() const{ return m_volumeEncryptionKMSKey; }
    inline bool VolumeEncryptionKMSKeyHasBeenSet() const { return m_volumeEncryptionKMSKeyHasBeenSet; }
    inline void SetVolumeEncryptionKMSKey(const Aws::String& value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey = value; }
    inline void SetVolumeEncryptionKMSKey(Aws::String&& value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey = std::move(value); }
    inline void SetVolumeEncryptionKMSKey(const char* value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey.assign(value); }
    inline StartMLModelTrainingJobRequest& WithVolumeEncryptionKMSKey(const Aws::String& value) { SetVolumeEncryptionKMSKey(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithVolumeEncryptionKMSKey(Aws::String&& value) { SetVolumeEncryptionKMSKey(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithVolumeEncryptionKMSKey(const char* value) { SetVolumeEncryptionKMSKey(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt
     * the output of the processing job. The default is none.</p>
     */
    inline const Aws::String& GetS3OutputEncryptionKMSKey() const{ return m_s3OutputEncryptionKMSKey; }
    inline bool S3OutputEncryptionKMSKeyHasBeenSet() const { return m_s3OutputEncryptionKMSKeyHasBeenSet; }
    inline void SetS3OutputEncryptionKMSKey(const Aws::String& value) { m_s3OutputEncryptionKMSKeyHasBeenSet = true; m_s3OutputEncryptionKMSKey = value; }
    inline void SetS3OutputEncryptionKMSKey(Aws::String&& value) { m_s3OutputEncryptionKMSKeyHasBeenSet = true; m_s3OutputEncryptionKMSKey = std::move(value); }
    inline void SetS3OutputEncryptionKMSKey(const char* value) { m_s3OutputEncryptionKMSKeyHasBeenSet = true; m_s3OutputEncryptionKMSKey.assign(value); }
    inline StartMLModelTrainingJobRequest& WithS3OutputEncryptionKMSKey(const Aws::String& value) { SetS3OutputEncryptionKMSKey(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithS3OutputEncryptionKMSKey(Aws::String&& value) { SetS3OutputEncryptionKMSKey(std::move(value)); return *this;}
    inline StartMLModelTrainingJobRequest& WithS3OutputEncryptionKMSKey(const char* value) { SetS3OutputEncryptionKMSKey(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Optimizes the cost of training machine-learning models by using Amazon
     * Elastic Compute Cloud spot instances. The default is <code>False</code>.</p>
     */
    inline bool GetEnableManagedSpotTraining() const{ return m_enableManagedSpotTraining; }
    inline bool EnableManagedSpotTrainingHasBeenSet() const { return m_enableManagedSpotTrainingHasBeenSet; }
    inline void SetEnableManagedSpotTraining(bool value) { m_enableManagedSpotTrainingHasBeenSet = true; m_enableManagedSpotTraining = value; }
    inline StartMLModelTrainingJobRequest& WithEnableManagedSpotTraining(bool value) { SetEnableManagedSpotTraining(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The configuration for custom model training. This is a JSON object.</p>
     */
    inline const CustomModelTrainingParameters& GetCustomModelTrainingParameters() const{ return m_customModelTrainingParameters; }
    inline bool CustomModelTrainingParametersHasBeenSet() const { return m_customModelTrainingParametersHasBeenSet; }
    inline void SetCustomModelTrainingParameters(const CustomModelTrainingParameters& value) { m_customModelTrainingParametersHasBeenSet = true; m_customModelTrainingParameters = value; }
    inline void SetCustomModelTrainingParameters(CustomModelTrainingParameters&& value) { m_customModelTrainingParametersHasBeenSet = true; m_customModelTrainingParameters = std::move(value); }
    inline StartMLModelTrainingJobRequest& WithCustomModelTrainingParameters(const CustomModelTrainingParameters& value) { SetCustomModelTrainingParameters(value); return *this;}
    inline StartMLModelTrainingJobRequest& WithCustomModelTrainingParameters(CustomModelTrainingParameters&& value) { SetCustomModelTrainingParameters(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::String m_previousModelTrainingJobId;
    bool m_previousModelTrainingJobIdHasBeenSet = false;

    Aws::String m_dataProcessingJobId;
    bool m_dataProcessingJobIdHasBeenSet = false;

    Aws::String m_trainModelS3Location;
    bool m_trainModelS3LocationHasBeenSet = false;

    Aws::String m_sagemakerIamRoleArn;
    bool m_sagemakerIamRoleArnHasBeenSet = false;

    Aws::String m_neptuneIamRoleArn;
    bool m_neptuneIamRoleArnHasBeenSet = false;

    Aws::String m_baseProcessingInstanceType;
    bool m_baseProcessingInstanceTypeHasBeenSet = false;

    Aws::String m_trainingInstanceType;
    bool m_trainingInstanceTypeHasBeenSet = false;

    int m_trainingInstanceVolumeSizeInGB;
    bool m_trainingInstanceVolumeSizeInGBHasBeenSet = false;

    int m_trainingTimeOutInSeconds;
    bool m_trainingTimeOutInSecondsHasBeenSet = false;

    int m_maxHPONumberOfTrainingJobs;
    bool m_maxHPONumberOfTrainingJobsHasBeenSet = false;

    int m_maxHPOParallelTrainingJobs;
    bool m_maxHPOParallelTrainingJobsHasBeenSet = false;

    Aws::Vector<Aws::String> m_subnets;
    bool m_subnetsHasBeenSet = false;

    Aws::Vector<Aws::String> m_securityGroupIds;
    bool m_securityGroupIdsHasBeenSet = false;

    Aws::String m_volumeEncryptionKMSKey;
    bool m_volumeEncryptionKMSKeyHasBeenSet = false;

    Aws::String m_s3OutputEncryptionKMSKey;
    bool m_s3OutputEncryptionKMSKeyHasBeenSet = false;

    bool m_enableManagedSpotTraining;
    bool m_enableManagedSpotTrainingHasBeenSet = false;

    CustomModelTrainingParameters m_customModelTrainingParameters;
    bool m_customModelTrainingParametersHasBeenSet = false;
  };

} // namespace Model
} // namespace neptunedata
} // namespace Aws
