﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/opensearch/OpenSearchService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/opensearch/model/OptionStatus.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace OpenSearchService
{
namespace Model
{

  /**
   * <p>The status of the the OpenSearch or Elasticsearch version options for the
   * specified Amazon OpenSearch Service domain.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/VersionStatus">AWS
   * API Reference</a></p>
   */
  class VersionStatus
  {
  public:
    AWS_OPENSEARCHSERVICE_API VersionStatus();
    AWS_OPENSEARCHSERVICE_API VersionStatus(Aws::Utils::Json::JsonView jsonValue);
    AWS_OPENSEARCHSERVICE_API VersionStatus& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_OPENSEARCHSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The OpenSearch or Elasticsearch version for the specified domain.</p>
     */
    inline const Aws::String& GetOptions() const{ return m_options; }
    inline bool OptionsHasBeenSet() const { return m_optionsHasBeenSet; }
    inline void SetOptions(const Aws::String& value) { m_optionsHasBeenSet = true; m_options = value; }
    inline void SetOptions(Aws::String&& value) { m_optionsHasBeenSet = true; m_options = std::move(value); }
    inline void SetOptions(const char* value) { m_optionsHasBeenSet = true; m_options.assign(value); }
    inline VersionStatus& WithOptions(const Aws::String& value) { SetOptions(value); return *this;}
    inline VersionStatus& WithOptions(Aws::String&& value) { SetOptions(std::move(value)); return *this;}
    inline VersionStatus& WithOptions(const char* value) { SetOptions(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The status of the version options for the specified domain.</p>
     */
    inline const OptionStatus& GetStatus() const{ return m_status; }
    inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
    inline void SetStatus(const OptionStatus& value) { m_statusHasBeenSet = true; m_status = value; }
    inline void SetStatus(OptionStatus&& value) { m_statusHasBeenSet = true; m_status = std::move(value); }
    inline VersionStatus& WithStatus(const OptionStatus& value) { SetStatus(value); return *this;}
    inline VersionStatus& WithStatus(OptionStatus&& value) { SetStatus(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_options;
    bool m_optionsHasBeenSet = false;

    OptionStatus m_status;
    bool m_statusHasBeenSet = false;
  };

} // namespace Model
} // namespace OpenSearchService
} // namespace Aws
