﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/payment-cryptography-data/PaymentCryptographyData_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/payment-cryptography-data/model/PinData.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace PaymentCryptographyData
{
namespace Model
{
  class GeneratePinDataResult
  {
  public:
    AWS_PAYMENTCRYPTOGRAPHYDATA_API GeneratePinDataResult();
    AWS_PAYMENTCRYPTOGRAPHYDATA_API GeneratePinDataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_PAYMENTCRYPTOGRAPHYDATA_API GeneratePinDataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The <code>keyARN</code> of the pin data generation key that Amazon Web
     * Services Payment Cryptography uses for PIN, PVV or PIN Offset generation.</p>
     */
    inline const Aws::String& GetGenerationKeyArn() const{ return m_generationKeyArn; }
    inline void SetGenerationKeyArn(const Aws::String& value) { m_generationKeyArn = value; }
    inline void SetGenerationKeyArn(Aws::String&& value) { m_generationKeyArn = std::move(value); }
    inline void SetGenerationKeyArn(const char* value) { m_generationKeyArn.assign(value); }
    inline GeneratePinDataResult& WithGenerationKeyArn(const Aws::String& value) { SetGenerationKeyArn(value); return *this;}
    inline GeneratePinDataResult& WithGenerationKeyArn(Aws::String&& value) { SetGenerationKeyArn(std::move(value)); return *this;}
    inline GeneratePinDataResult& WithGenerationKeyArn(const char* value) { SetGenerationKeyArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The key check value (KCV) of the encryption key. The KCV is used to check if
     * all parties holding a given key have the same key or to detect that a key has
     * changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV
     * according to the CMAC specification.</p>
     */
    inline const Aws::String& GetGenerationKeyCheckValue() const{ return m_generationKeyCheckValue; }
    inline void SetGenerationKeyCheckValue(const Aws::String& value) { m_generationKeyCheckValue = value; }
    inline void SetGenerationKeyCheckValue(Aws::String&& value) { m_generationKeyCheckValue = std::move(value); }
    inline void SetGenerationKeyCheckValue(const char* value) { m_generationKeyCheckValue.assign(value); }
    inline GeneratePinDataResult& WithGenerationKeyCheckValue(const Aws::String& value) { SetGenerationKeyCheckValue(value); return *this;}
    inline GeneratePinDataResult& WithGenerationKeyCheckValue(Aws::String&& value) { SetGenerationKeyCheckValue(std::move(value)); return *this;}
    inline GeneratePinDataResult& WithGenerationKeyCheckValue(const char* value) { SetGenerationKeyCheckValue(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The <code>keyARN</code> of the PEK that Amazon Web Services Payment
     * Cryptography uses for encrypted pin block generation. For ECDH, it is the
     * <code>keyARN</code> of the asymmetric ECC key.</p>
     */
    inline const Aws::String& GetEncryptionKeyArn() const{ return m_encryptionKeyArn; }
    inline void SetEncryptionKeyArn(const Aws::String& value) { m_encryptionKeyArn = value; }
    inline void SetEncryptionKeyArn(Aws::String&& value) { m_encryptionKeyArn = std::move(value); }
    inline void SetEncryptionKeyArn(const char* value) { m_encryptionKeyArn.assign(value); }
    inline GeneratePinDataResult& WithEncryptionKeyArn(const Aws::String& value) { SetEncryptionKeyArn(value); return *this;}
    inline GeneratePinDataResult& WithEncryptionKeyArn(Aws::String&& value) { SetEncryptionKeyArn(std::move(value)); return *this;}
    inline GeneratePinDataResult& WithEncryptionKeyArn(const char* value) { SetEncryptionKeyArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The key check value (KCV) of the encryption key. The KCV is used to check if
     * all parties holding a given key have the same key or to detect that a key has
     * changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV
     * according to the CMAC specification.</p>
     */
    inline const Aws::String& GetEncryptionKeyCheckValue() const{ return m_encryptionKeyCheckValue; }
    inline void SetEncryptionKeyCheckValue(const Aws::String& value) { m_encryptionKeyCheckValue = value; }
    inline void SetEncryptionKeyCheckValue(Aws::String&& value) { m_encryptionKeyCheckValue = std::move(value); }
    inline void SetEncryptionKeyCheckValue(const char* value) { m_encryptionKeyCheckValue.assign(value); }
    inline GeneratePinDataResult& WithEncryptionKeyCheckValue(const Aws::String& value) { SetEncryptionKeyCheckValue(value); return *this;}
    inline GeneratePinDataResult& WithEncryptionKeyCheckValue(Aws::String&& value) { SetEncryptionKeyCheckValue(std::move(value)); return *this;}
    inline GeneratePinDataResult& WithEncryptionKeyCheckValue(const char* value) { SetEncryptionKeyCheckValue(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The PIN block encrypted under PEK from Amazon Web Services Payment
     * Cryptography. The encrypted PIN block is a composite of PAN (Primary Account
     * Number) and PIN (Personal Identification Number), generated in accordance with
     * ISO 9564 standard.</p>
     */
    inline const Aws::String& GetEncryptedPinBlock() const{ return m_encryptedPinBlock; }
    inline void SetEncryptedPinBlock(const Aws::String& value) { m_encryptedPinBlock = value; }
    inline void SetEncryptedPinBlock(Aws::String&& value) { m_encryptedPinBlock = std::move(value); }
    inline void SetEncryptedPinBlock(const char* value) { m_encryptedPinBlock.assign(value); }
    inline GeneratePinDataResult& WithEncryptedPinBlock(const Aws::String& value) { SetEncryptedPinBlock(value); return *this;}
    inline GeneratePinDataResult& WithEncryptedPinBlock(Aws::String&& value) { SetEncryptedPinBlock(std::move(value)); return *this;}
    inline GeneratePinDataResult& WithEncryptedPinBlock(const char* value) { SetEncryptedPinBlock(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The attributes and values Amazon Web Services Payment Cryptography uses for
     * pin data generation.</p>
     */
    inline const PinData& GetPinData() const{ return m_pinData; }
    inline void SetPinData(const PinData& value) { m_pinData = value; }
    inline void SetPinData(PinData&& value) { m_pinData = std::move(value); }
    inline GeneratePinDataResult& WithPinData(const PinData& value) { SetPinData(value); return *this;}
    inline GeneratePinDataResult& WithPinData(PinData&& value) { SetPinData(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GeneratePinDataResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GeneratePinDataResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GeneratePinDataResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_generationKeyArn;

    Aws::String m_generationKeyCheckValue;

    Aws::String m_encryptionKeyArn;

    Aws::String m_encryptionKeyCheckValue;

    Aws::String m_encryptedPinBlock;

    PinData m_pinData;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace PaymentCryptographyData
} // namespace Aws
