﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/PinpointRequest.h>
#include <aws/pinpoint/model/EmailTemplateRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Pinpoint
{
namespace Model
{

  /**
   */
  class CreateEmailTemplateRequest : public PinpointRequest
  {
  public:
    AWS_PINPOINT_API CreateEmailTemplateRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CreateEmailTemplate"; }

    AWS_PINPOINT_API Aws::String SerializePayload() const override;


    ///@{
    
    inline const EmailTemplateRequest& GetEmailTemplateRequest() const{ return m_emailTemplateRequest; }
    inline bool EmailTemplateRequestHasBeenSet() const { return m_emailTemplateRequestHasBeenSet; }
    inline void SetEmailTemplateRequest(const EmailTemplateRequest& value) { m_emailTemplateRequestHasBeenSet = true; m_emailTemplateRequest = value; }
    inline void SetEmailTemplateRequest(EmailTemplateRequest&& value) { m_emailTemplateRequestHasBeenSet = true; m_emailTemplateRequest = std::move(value); }
    inline CreateEmailTemplateRequest& WithEmailTemplateRequest(const EmailTemplateRequest& value) { SetEmailTemplateRequest(value); return *this;}
    inline CreateEmailTemplateRequest& WithEmailTemplateRequest(EmailTemplateRequest&& value) { SetEmailTemplateRequest(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the message template. A template name must start with an
     * alphanumeric character and can contain a maximum of 128 characters. The
     * characters can be alphanumeric characters, underscores (_), or hyphens (-).
     * Template names are case sensitive.</p>
     */
    inline const Aws::String& GetTemplateName() const{ return m_templateName; }
    inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
    inline void SetTemplateName(const Aws::String& value) { m_templateNameHasBeenSet = true; m_templateName = value; }
    inline void SetTemplateName(Aws::String&& value) { m_templateNameHasBeenSet = true; m_templateName = std::move(value); }
    inline void SetTemplateName(const char* value) { m_templateNameHasBeenSet = true; m_templateName.assign(value); }
    inline CreateEmailTemplateRequest& WithTemplateName(const Aws::String& value) { SetTemplateName(value); return *this;}
    inline CreateEmailTemplateRequest& WithTemplateName(Aws::String&& value) { SetTemplateName(std::move(value)); return *this;}
    inline CreateEmailTemplateRequest& WithTemplateName(const char* value) { SetTemplateName(value); return *this;}
    ///@}
  private:

    EmailTemplateRequest m_emailTemplateRequest;
    bool m_emailTemplateRequestHasBeenSet = false;

    Aws::String m_templateName;
    bool m_templateNameHasBeenSet = false;
  };

} // namespace Model
} // namespace Pinpoint
} // namespace Aws
