﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/model/SetDimension.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Pinpoint
{
namespace Model
{

  /**
   * <p>Specifies demographic-based dimension settings for including or excluding
   * endpoints from a segment. These settings derive from characteristics of endpoint
   * devices, such as platform, make, and model.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentDemographics">AWS
   * API Reference</a></p>
   */
  class SegmentDemographics
  {
  public:
    AWS_PINPOINT_API SegmentDemographics();
    AWS_PINPOINT_API SegmentDemographics(Aws::Utils::Json::JsonView jsonValue);
    AWS_PINPOINT_API SegmentDemographics& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_PINPOINT_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The app version criteria for the segment.</p>
     */
    inline const SetDimension& GetAppVersion() const{ return m_appVersion; }
    inline bool AppVersionHasBeenSet() const { return m_appVersionHasBeenSet; }
    inline void SetAppVersion(const SetDimension& value) { m_appVersionHasBeenSet = true; m_appVersion = value; }
    inline void SetAppVersion(SetDimension&& value) { m_appVersionHasBeenSet = true; m_appVersion = std::move(value); }
    inline SegmentDemographics& WithAppVersion(const SetDimension& value) { SetAppVersion(value); return *this;}
    inline SegmentDemographics& WithAppVersion(SetDimension&& value) { SetAppVersion(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The channel criteria for the segment.</p>
     */
    inline const SetDimension& GetChannel() const{ return m_channel; }
    inline bool ChannelHasBeenSet() const { return m_channelHasBeenSet; }
    inline void SetChannel(const SetDimension& value) { m_channelHasBeenSet = true; m_channel = value; }
    inline void SetChannel(SetDimension&& value) { m_channelHasBeenSet = true; m_channel = std::move(value); }
    inline SegmentDemographics& WithChannel(const SetDimension& value) { SetChannel(value); return *this;}
    inline SegmentDemographics& WithChannel(SetDimension&& value) { SetChannel(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The device type criteria for the segment.</p>
     */
    inline const SetDimension& GetDeviceType() const{ return m_deviceType; }
    inline bool DeviceTypeHasBeenSet() const { return m_deviceTypeHasBeenSet; }
    inline void SetDeviceType(const SetDimension& value) { m_deviceTypeHasBeenSet = true; m_deviceType = value; }
    inline void SetDeviceType(SetDimension&& value) { m_deviceTypeHasBeenSet = true; m_deviceType = std::move(value); }
    inline SegmentDemographics& WithDeviceType(const SetDimension& value) { SetDeviceType(value); return *this;}
    inline SegmentDemographics& WithDeviceType(SetDimension&& value) { SetDeviceType(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The device make criteria for the segment.</p>
     */
    inline const SetDimension& GetMake() const{ return m_make; }
    inline bool MakeHasBeenSet() const { return m_makeHasBeenSet; }
    inline void SetMake(const SetDimension& value) { m_makeHasBeenSet = true; m_make = value; }
    inline void SetMake(SetDimension&& value) { m_makeHasBeenSet = true; m_make = std::move(value); }
    inline SegmentDemographics& WithMake(const SetDimension& value) { SetMake(value); return *this;}
    inline SegmentDemographics& WithMake(SetDimension&& value) { SetMake(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The device model criteria for the segment.</p>
     */
    inline const SetDimension& GetModel() const{ return m_model; }
    inline bool ModelHasBeenSet() const { return m_modelHasBeenSet; }
    inline void SetModel(const SetDimension& value) { m_modelHasBeenSet = true; m_model = value; }
    inline void SetModel(SetDimension&& value) { m_modelHasBeenSet = true; m_model = std::move(value); }
    inline SegmentDemographics& WithModel(const SetDimension& value) { SetModel(value); return *this;}
    inline SegmentDemographics& WithModel(SetDimension&& value) { SetModel(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The device platform criteria for the segment.</p>
     */
    inline const SetDimension& GetPlatform() const{ return m_platform; }
    inline bool PlatformHasBeenSet() const { return m_platformHasBeenSet; }
    inline void SetPlatform(const SetDimension& value) { m_platformHasBeenSet = true; m_platform = value; }
    inline void SetPlatform(SetDimension&& value) { m_platformHasBeenSet = true; m_platform = std::move(value); }
    inline SegmentDemographics& WithPlatform(const SetDimension& value) { SetPlatform(value); return *this;}
    inline SegmentDemographics& WithPlatform(SetDimension&& value) { SetPlatform(std::move(value)); return *this;}
    ///@}
  private:

    SetDimension m_appVersion;
    bool m_appVersionHasBeenSet = false;

    SetDimension m_channel;
    bool m_channelHasBeenSet = false;

    SetDimension m_deviceType;
    bool m_deviceTypeHasBeenSet = false;

    SetDimension m_make;
    bool m_makeHasBeenSet = false;

    SetDimension m_model;
    bool m_modelHasBeenSet = false;

    SetDimension m_platform;
    bool m_platformHasBeenSet = false;
  };

} // namespace Model
} // namespace Pinpoint
} // namespace Aws
