﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/model/VPCConnectionResourceStatus.h>
#include <aws/quicksight/model/VPCConnectionAvailabilityStatus.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace QuickSight
{
namespace Model
{
  class DeleteVPCConnectionResult
  {
  public:
    AWS_QUICKSIGHT_API DeleteVPCConnectionResult();
    AWS_QUICKSIGHT_API DeleteVPCConnectionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_QUICKSIGHT_API DeleteVPCConnectionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the deleted VPC connection.</p>
     */
    inline const Aws::String& GetArn() const{ return m_arn; }
    inline void SetArn(const Aws::String& value) { m_arn = value; }
    inline void SetArn(Aws::String&& value) { m_arn = std::move(value); }
    inline void SetArn(const char* value) { m_arn.assign(value); }
    inline DeleteVPCConnectionResult& WithArn(const Aws::String& value) { SetArn(value); return *this;}
    inline DeleteVPCConnectionResult& WithArn(Aws::String&& value) { SetArn(std::move(value)); return *this;}
    inline DeleteVPCConnectionResult& WithArn(const char* value) { SetArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of the VPC connection that you're creating. This ID is a unique
     * identifier for each Amazon Web Services Region in an Amazon Web Services
     * account.</p>
     */
    inline const Aws::String& GetVPCConnectionId() const{ return m_vPCConnectionId; }
    inline void SetVPCConnectionId(const Aws::String& value) { m_vPCConnectionId = value; }
    inline void SetVPCConnectionId(Aws::String&& value) { m_vPCConnectionId = std::move(value); }
    inline void SetVPCConnectionId(const char* value) { m_vPCConnectionId.assign(value); }
    inline DeleteVPCConnectionResult& WithVPCConnectionId(const Aws::String& value) { SetVPCConnectionId(value); return *this;}
    inline DeleteVPCConnectionResult& WithVPCConnectionId(Aws::String&& value) { SetVPCConnectionId(std::move(value)); return *this;}
    inline DeleteVPCConnectionResult& WithVPCConnectionId(const char* value) { SetVPCConnectionId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The deletion status of the VPC connection.</p>
     */
    inline const VPCConnectionResourceStatus& GetDeletionStatus() const{ return m_deletionStatus; }
    inline void SetDeletionStatus(const VPCConnectionResourceStatus& value) { m_deletionStatus = value; }
    inline void SetDeletionStatus(VPCConnectionResourceStatus&& value) { m_deletionStatus = std::move(value); }
    inline DeleteVPCConnectionResult& WithDeletionStatus(const VPCConnectionResourceStatus& value) { SetDeletionStatus(value); return *this;}
    inline DeleteVPCConnectionResult& WithDeletionStatus(VPCConnectionResourceStatus&& value) { SetDeletionStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The availability status of the VPC connection.</p>
     */
    inline const VPCConnectionAvailabilityStatus& GetAvailabilityStatus() const{ return m_availabilityStatus; }
    inline void SetAvailabilityStatus(const VPCConnectionAvailabilityStatus& value) { m_availabilityStatus = value; }
    inline void SetAvailabilityStatus(VPCConnectionAvailabilityStatus&& value) { m_availabilityStatus = std::move(value); }
    inline DeleteVPCConnectionResult& WithAvailabilityStatus(const VPCConnectionAvailabilityStatus& value) { SetAvailabilityStatus(value); return *this;}
    inline DeleteVPCConnectionResult& WithAvailabilityStatus(VPCConnectionAvailabilityStatus&& value) { SetAvailabilityStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DeleteVPCConnectionResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DeleteVPCConnectionResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DeleteVPCConnectionResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The HTTP status of the request.</p>
     */
    inline int GetStatus() const{ return m_status; }
    inline void SetStatus(int value) { m_status = value; }
    inline DeleteVPCConnectionResult& WithStatus(int value) { SetStatus(value); return *this;}
    ///@}
  private:

    Aws::String m_arn;

    Aws::String m_vPCConnectionId;

    VPCConnectionResourceStatus m_deletionStatus;

    VPCConnectionAvailabilityStatus m_availabilityStatus;

    Aws::String m_requestId;

    int m_status;
  };

} // namespace Model
} // namespace QuickSight
} // namespace Aws
