﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/rds/RDS_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Xml
{
  class XmlNode;
} // namespace Xml
} // namespace Utils
namespace RDS
{
namespace Model
{

  /**
   * <p>A logical grouping of Performance Insights metrics for a related subject
   * area. For example, the <code>db.sql</code> dimension group consists of the
   * following dimensions: </p> <ul> <li> <p> <code>db.sql.id</code> - The hash of a
   * running SQL statement, generated by Performance Insights.</p> </li> <li> <p>
   * <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine,
   * or a value generated by Performance Insights that begins with
   * <code>pi-</code>.</p> </li> <li> <p> <code>db.sql.statement</code> - The full
   * text of the SQL statement that is running, for example, <code>SELECT * FROM
   * employees</code>.</p> </li> <li> <p> <code>db.sql_tokenized.id</code> - The hash
   * of the SQL digest generated by Performance Insights.</p> </li> </ul> 
   * <p>Each response element returns a maximum of 500 bytes. For larger elements,
   * such as SQL statements, only the first 500 bytes are returned.</p>
   * <p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PerformanceInsightsMetricDimensionGroup">AWS
   * API Reference</a></p>
   */
  class PerformanceInsightsMetricDimensionGroup
  {
  public:
    AWS_RDS_API PerformanceInsightsMetricDimensionGroup();
    AWS_RDS_API PerformanceInsightsMetricDimensionGroup(const Aws::Utils::Xml::XmlNode& xmlNode);
    AWS_RDS_API PerformanceInsightsMetricDimensionGroup& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

    AWS_RDS_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
    AWS_RDS_API void OutputToStream(Aws::OStream& oStream, const char* location) const;


    ///@{
    /**
     * <p>A list of specific dimensions from a dimension group. If this list isn't
     * included, then all of the dimensions in the group were requested, or are present
     * in the response.</p>
     */
    inline const Aws::Vector<Aws::String>& GetDimensions() const{ return m_dimensions; }
    inline bool DimensionsHasBeenSet() const { return m_dimensionsHasBeenSet; }
    inline void SetDimensions(const Aws::Vector<Aws::String>& value) { m_dimensionsHasBeenSet = true; m_dimensions = value; }
    inline void SetDimensions(Aws::Vector<Aws::String>&& value) { m_dimensionsHasBeenSet = true; m_dimensions = std::move(value); }
    inline PerformanceInsightsMetricDimensionGroup& WithDimensions(const Aws::Vector<Aws::String>& value) { SetDimensions(value); return *this;}
    inline PerformanceInsightsMetricDimensionGroup& WithDimensions(Aws::Vector<Aws::String>&& value) { SetDimensions(std::move(value)); return *this;}
    inline PerformanceInsightsMetricDimensionGroup& AddDimensions(const Aws::String& value) { m_dimensionsHasBeenSet = true; m_dimensions.push_back(value); return *this; }
    inline PerformanceInsightsMetricDimensionGroup& AddDimensions(Aws::String&& value) { m_dimensionsHasBeenSet = true; m_dimensions.push_back(std::move(value)); return *this; }
    inline PerformanceInsightsMetricDimensionGroup& AddDimensions(const char* value) { m_dimensionsHasBeenSet = true; m_dimensions.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The available dimension groups for Performance Insights metric type.</p>
     */
    inline const Aws::String& GetGroup() const{ return m_group; }
    inline bool GroupHasBeenSet() const { return m_groupHasBeenSet; }
    inline void SetGroup(const Aws::String& value) { m_groupHasBeenSet = true; m_group = value; }
    inline void SetGroup(Aws::String&& value) { m_groupHasBeenSet = true; m_group = std::move(value); }
    inline void SetGroup(const char* value) { m_groupHasBeenSet = true; m_group.assign(value); }
    inline PerformanceInsightsMetricDimensionGroup& WithGroup(const Aws::String& value) { SetGroup(value); return *this;}
    inline PerformanceInsightsMetricDimensionGroup& WithGroup(Aws::String&& value) { SetGroup(std::move(value)); return *this;}
    inline PerformanceInsightsMetricDimensionGroup& WithGroup(const char* value) { SetGroup(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The maximum number of items to fetch for this dimension group.</p>
     */
    inline int GetLimit() const{ return m_limit; }
    inline bool LimitHasBeenSet() const { return m_limitHasBeenSet; }
    inline void SetLimit(int value) { m_limitHasBeenSet = true; m_limit = value; }
    inline PerformanceInsightsMetricDimensionGroup& WithLimit(int value) { SetLimit(value); return *this;}
    ///@}
  private:

    Aws::Vector<Aws::String> m_dimensions;
    bool m_dimensionsHasBeenSet = false;

    Aws::String m_group;
    bool m_groupHasBeenSet = false;

    int m_limit;
    bool m_limitHasBeenSet = false;
  };

} // namespace Model
} // namespace RDS
} // namespace Aws
