﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/rekognition/Rekognition_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/rekognition/model/OrientationCorrection.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/rekognition/model/DetectLabelsImageProperties.h>
#include <aws/rekognition/model/Label.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Rekognition
{
namespace Model
{
  class DetectLabelsResult
  {
  public:
    AWS_REKOGNITION_API DetectLabelsResult();
    AWS_REKOGNITION_API DetectLabelsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_REKOGNITION_API DetectLabelsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>An array of labels for the real-world objects detected. </p>
     */
    inline const Aws::Vector<Label>& GetLabels() const{ return m_labels; }
    inline void SetLabels(const Aws::Vector<Label>& value) { m_labels = value; }
    inline void SetLabels(Aws::Vector<Label>&& value) { m_labels = std::move(value); }
    inline DetectLabelsResult& WithLabels(const Aws::Vector<Label>& value) { SetLabels(value); return *this;}
    inline DetectLabelsResult& WithLabels(Aws::Vector<Label>&& value) { SetLabels(std::move(value)); return *this;}
    inline DetectLabelsResult& AddLabels(const Label& value) { m_labels.push_back(value); return *this; }
    inline DetectLabelsResult& AddLabels(Label&& value) { m_labels.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The value of <code>OrientationCorrection</code> is always null.</p> <p>If the
     * input image is in .jpeg format, it might contain exchangeable image file format
     * (Exif) metadata that includes the image's orientation. Amazon Rekognition uses
     * this orientation information to perform image correction. The bounding box
     * coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation.
     * Images in .png format don't contain Exif metadata.</p> <p>Amazon Rekognition
     * doesn’t perform image correction for images in .png format and .jpeg images
     * without orientation information in the image Exif metadata. The bounding box
     * coordinates aren't translated and represent the object locations before the
     * image is rotated. </p>
     */
    inline const OrientationCorrection& GetOrientationCorrection() const{ return m_orientationCorrection; }
    inline void SetOrientationCorrection(const OrientationCorrection& value) { m_orientationCorrection = value; }
    inline void SetOrientationCorrection(OrientationCorrection&& value) { m_orientationCorrection = std::move(value); }
    inline DetectLabelsResult& WithOrientationCorrection(const OrientationCorrection& value) { SetOrientationCorrection(value); return *this;}
    inline DetectLabelsResult& WithOrientationCorrection(OrientationCorrection&& value) { SetOrientationCorrection(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Version number of the label detection model that was used to detect
     * labels.</p>
     */
    inline const Aws::String& GetLabelModelVersion() const{ return m_labelModelVersion; }
    inline void SetLabelModelVersion(const Aws::String& value) { m_labelModelVersion = value; }
    inline void SetLabelModelVersion(Aws::String&& value) { m_labelModelVersion = std::move(value); }
    inline void SetLabelModelVersion(const char* value) { m_labelModelVersion.assign(value); }
    inline DetectLabelsResult& WithLabelModelVersion(const Aws::String& value) { SetLabelModelVersion(value); return *this;}
    inline DetectLabelsResult& WithLabelModelVersion(Aws::String&& value) { SetLabelModelVersion(std::move(value)); return *this;}
    inline DetectLabelsResult& WithLabelModelVersion(const char* value) { SetLabelModelVersion(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the properties of the input image, such as brightness,
     * sharpness, contrast, and dominant colors.</p>
     */
    inline const DetectLabelsImageProperties& GetImageProperties() const{ return m_imageProperties; }
    inline void SetImageProperties(const DetectLabelsImageProperties& value) { m_imageProperties = value; }
    inline void SetImageProperties(DetectLabelsImageProperties&& value) { m_imageProperties = std::move(value); }
    inline DetectLabelsResult& WithImageProperties(const DetectLabelsImageProperties& value) { SetImageProperties(value); return *this;}
    inline DetectLabelsResult& WithImageProperties(DetectLabelsImageProperties&& value) { SetImageProperties(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DetectLabelsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DetectLabelsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DetectLabelsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<Label> m_labels;

    OrientationCorrection m_orientationCorrection;

    Aws::String m_labelModelVersion;

    DetectLabelsImageProperties m_imageProperties;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Rekognition
} // namespace Aws
