﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/repostspace/Repostspace_EXPORTS.h>
#include <aws/repostspace/RepostspaceRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace repostspace
{
namespace Model
{

  /**
   */
  class RegisterAdminRequest : public RepostspaceRequest
  {
  public:
    AWS_REPOSTSPACE_API RegisterAdminRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "RegisterAdmin"; }

    AWS_REPOSTSPACE_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The ID of the administrator.</p>
     */
    inline const Aws::String& GetAdminId() const{ return m_adminId; }
    inline bool AdminIdHasBeenSet() const { return m_adminIdHasBeenSet; }
    inline void SetAdminId(const Aws::String& value) { m_adminIdHasBeenSet = true; m_adminId = value; }
    inline void SetAdminId(Aws::String&& value) { m_adminIdHasBeenSet = true; m_adminId = std::move(value); }
    inline void SetAdminId(const char* value) { m_adminIdHasBeenSet = true; m_adminId.assign(value); }
    inline RegisterAdminRequest& WithAdminId(const Aws::String& value) { SetAdminId(value); return *this;}
    inline RegisterAdminRequest& WithAdminId(Aws::String&& value) { SetAdminId(std::move(value)); return *this;}
    inline RegisterAdminRequest& WithAdminId(const char* value) { SetAdminId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of the private re:Post.</p>
     */
    inline const Aws::String& GetSpaceId() const{ return m_spaceId; }
    inline bool SpaceIdHasBeenSet() const { return m_spaceIdHasBeenSet; }
    inline void SetSpaceId(const Aws::String& value) { m_spaceIdHasBeenSet = true; m_spaceId = value; }
    inline void SetSpaceId(Aws::String&& value) { m_spaceIdHasBeenSet = true; m_spaceId = std::move(value); }
    inline void SetSpaceId(const char* value) { m_spaceIdHasBeenSet = true; m_spaceId.assign(value); }
    inline RegisterAdminRequest& WithSpaceId(const Aws::String& value) { SetSpaceId(value); return *this;}
    inline RegisterAdminRequest& WithSpaceId(Aws::String&& value) { SetSpaceId(std::move(value)); return *this;}
    inline RegisterAdminRequest& WithSpaceId(const char* value) { SetSpaceId(value); return *this;}
    ///@}
  private:

    Aws::String m_adminId;
    bool m_adminIdHasBeenSet = false;

    Aws::String m_spaceId;
    bool m_spaceIdHasBeenSet = false;
  };

} // namespace Model
} // namespace repostspace
} // namespace Aws
