﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/model/FlowDefinitionSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SageMaker
{
namespace Model
{
  class ListFlowDefinitionsResult
  {
  public:
    AWS_SAGEMAKER_API ListFlowDefinitionsResult();
    AWS_SAGEMAKER_API ListFlowDefinitionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SAGEMAKER_API ListFlowDefinitionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>An array of objects describing the flow definitions.</p>
     */
    inline const Aws::Vector<FlowDefinitionSummary>& GetFlowDefinitionSummaries() const{ return m_flowDefinitionSummaries; }
    inline void SetFlowDefinitionSummaries(const Aws::Vector<FlowDefinitionSummary>& value) { m_flowDefinitionSummaries = value; }
    inline void SetFlowDefinitionSummaries(Aws::Vector<FlowDefinitionSummary>&& value) { m_flowDefinitionSummaries = std::move(value); }
    inline ListFlowDefinitionsResult& WithFlowDefinitionSummaries(const Aws::Vector<FlowDefinitionSummary>& value) { SetFlowDefinitionSummaries(value); return *this;}
    inline ListFlowDefinitionsResult& WithFlowDefinitionSummaries(Aws::Vector<FlowDefinitionSummary>&& value) { SetFlowDefinitionSummaries(std::move(value)); return *this;}
    inline ListFlowDefinitionsResult& AddFlowDefinitionSummaries(const FlowDefinitionSummary& value) { m_flowDefinitionSummaries.push_back(value); return *this; }
    inline ListFlowDefinitionsResult& AddFlowDefinitionSummaries(FlowDefinitionSummary&& value) { m_flowDefinitionSummaries.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A token to resume pagination.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListFlowDefinitionsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListFlowDefinitionsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListFlowDefinitionsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListFlowDefinitionsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListFlowDefinitionsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListFlowDefinitionsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<FlowDefinitionSummary> m_flowDefinitionSummaries;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SageMaker
} // namespace Aws
