﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SageMaker
{
namespace Model
{

  /**
   * <p>The workspace settings for the SageMaker Canvas application.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/WorkspaceSettings">AWS
   * API Reference</a></p>
   */
  class WorkspaceSettings
  {
  public:
    AWS_SAGEMAKER_API WorkspaceSettings();
    AWS_SAGEMAKER_API WorkspaceSettings(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKER_API WorkspaceSettings& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The Amazon S3 bucket used to store artifacts generated by Canvas. Updating
     * the Amazon S3 location impacts existing configuration settings, and Canvas users
     * no longer have access to their artifacts. Canvas users must log out and log back
     * in to apply the new location.</p>
     */
    inline const Aws::String& GetS3ArtifactPath() const{ return m_s3ArtifactPath; }
    inline bool S3ArtifactPathHasBeenSet() const { return m_s3ArtifactPathHasBeenSet; }
    inline void SetS3ArtifactPath(const Aws::String& value) { m_s3ArtifactPathHasBeenSet = true; m_s3ArtifactPath = value; }
    inline void SetS3ArtifactPath(Aws::String&& value) { m_s3ArtifactPathHasBeenSet = true; m_s3ArtifactPath = std::move(value); }
    inline void SetS3ArtifactPath(const char* value) { m_s3ArtifactPathHasBeenSet = true; m_s3ArtifactPath.assign(value); }
    inline WorkspaceSettings& WithS3ArtifactPath(const Aws::String& value) { SetS3ArtifactPath(value); return *this;}
    inline WorkspaceSettings& WithS3ArtifactPath(Aws::String&& value) { SetS3ArtifactPath(std::move(value)); return *this;}
    inline WorkspaceSettings& WithS3ArtifactPath(const char* value) { SetS3ArtifactPath(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Web Services Key Management Service (KMS) encryption key ID that
     * is used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.</p>
     */
    inline const Aws::String& GetS3KmsKeyId() const{ return m_s3KmsKeyId; }
    inline bool S3KmsKeyIdHasBeenSet() const { return m_s3KmsKeyIdHasBeenSet; }
    inline void SetS3KmsKeyId(const Aws::String& value) { m_s3KmsKeyIdHasBeenSet = true; m_s3KmsKeyId = value; }
    inline void SetS3KmsKeyId(Aws::String&& value) { m_s3KmsKeyIdHasBeenSet = true; m_s3KmsKeyId = std::move(value); }
    inline void SetS3KmsKeyId(const char* value) { m_s3KmsKeyIdHasBeenSet = true; m_s3KmsKeyId.assign(value); }
    inline WorkspaceSettings& WithS3KmsKeyId(const Aws::String& value) { SetS3KmsKeyId(value); return *this;}
    inline WorkspaceSettings& WithS3KmsKeyId(Aws::String&& value) { SetS3KmsKeyId(std::move(value)); return *this;}
    inline WorkspaceSettings& WithS3KmsKeyId(const char* value) { SetS3KmsKeyId(value); return *this;}
    ///@}
  private:

    Aws::String m_s3ArtifactPath;
    bool m_s3ArtifactPathHasBeenSet = false;

    Aws::String m_s3KmsKeyId;
    bool m_s3KmsKeyIdHasBeenSet = false;
  };

} // namespace Model
} // namespace SageMaker
} // namespace Aws
