﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/socialmessaging/SocialMessaging_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/socialmessaging/model/LinkedWhatsAppBusinessAccountIdMetaData.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SocialMessaging
{
namespace Model
{

  /**
   * <p>Contains the results of WhatsAppSignupCallback.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/WhatsAppSignupCallbackResult">AWS
   * API Reference</a></p>
   */
  class WhatsAppSignupCallbackResult
  {
  public:
    AWS_SOCIALMESSAGING_API WhatsAppSignupCallbackResult();
    AWS_SOCIALMESSAGING_API WhatsAppSignupCallbackResult(Aws::Utils::Json::JsonView jsonValue);
    AWS_SOCIALMESSAGING_API WhatsAppSignupCallbackResult& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SOCIALMESSAGING_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>An Amazon Web Services access token generated by
     * <code>WhatsAppSignupCallback</code> and used by
     * <code>WhatsAppSetupFinalization</code>.</p>
     */
    inline const Aws::String& GetAssociateInProgressToken() const{ return m_associateInProgressToken; }
    inline bool AssociateInProgressTokenHasBeenSet() const { return m_associateInProgressTokenHasBeenSet; }
    inline void SetAssociateInProgressToken(const Aws::String& value) { m_associateInProgressTokenHasBeenSet = true; m_associateInProgressToken = value; }
    inline void SetAssociateInProgressToken(Aws::String&& value) { m_associateInProgressTokenHasBeenSet = true; m_associateInProgressToken = std::move(value); }
    inline void SetAssociateInProgressToken(const char* value) { m_associateInProgressTokenHasBeenSet = true; m_associateInProgressToken.assign(value); }
    inline WhatsAppSignupCallbackResult& WithAssociateInProgressToken(const Aws::String& value) { SetAssociateInProgressToken(value); return *this;}
    inline WhatsAppSignupCallbackResult& WithAssociateInProgressToken(Aws::String&& value) { SetAssociateInProgressToken(std::move(value)); return *this;}
    inline WhatsAppSignupCallbackResult& WithAssociateInProgressToken(const char* value) { SetAssociateInProgressToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A LinkedWhatsAppBusinessAccountIdMetaData object map containing the details
     * of any WhatsAppBusiness accounts that have incomplete setup.</p>
     */
    inline const Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData>& GetLinkedAccountsWithIncompleteSetup() const{ return m_linkedAccountsWithIncompleteSetup; }
    inline bool LinkedAccountsWithIncompleteSetupHasBeenSet() const { return m_linkedAccountsWithIncompleteSetupHasBeenSet; }
    inline void SetLinkedAccountsWithIncompleteSetup(const Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData>& value) { m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup = value; }
    inline void SetLinkedAccountsWithIncompleteSetup(Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData>&& value) { m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup = std::move(value); }
    inline WhatsAppSignupCallbackResult& WithLinkedAccountsWithIncompleteSetup(const Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData>& value) { SetLinkedAccountsWithIncompleteSetup(value); return *this;}
    inline WhatsAppSignupCallbackResult& WithLinkedAccountsWithIncompleteSetup(Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData>&& value) { SetLinkedAccountsWithIncompleteSetup(std::move(value)); return *this;}
    inline WhatsAppSignupCallbackResult& AddLinkedAccountsWithIncompleteSetup(const Aws::String& key, const LinkedWhatsAppBusinessAccountIdMetaData& value) { m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup.emplace(key, value); return *this; }
    inline WhatsAppSignupCallbackResult& AddLinkedAccountsWithIncompleteSetup(Aws::String&& key, const LinkedWhatsAppBusinessAccountIdMetaData& value) { m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup.emplace(std::move(key), value); return *this; }
    inline WhatsAppSignupCallbackResult& AddLinkedAccountsWithIncompleteSetup(const Aws::String& key, LinkedWhatsAppBusinessAccountIdMetaData&& value) { m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup.emplace(key, std::move(value)); return *this; }
    inline WhatsAppSignupCallbackResult& AddLinkedAccountsWithIncompleteSetup(Aws::String&& key, LinkedWhatsAppBusinessAccountIdMetaData&& value) { m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup.emplace(std::move(key), std::move(value)); return *this; }
    inline WhatsAppSignupCallbackResult& AddLinkedAccountsWithIncompleteSetup(const char* key, LinkedWhatsAppBusinessAccountIdMetaData&& value) { m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup.emplace(key, std::move(value)); return *this; }
    inline WhatsAppSignupCallbackResult& AddLinkedAccountsWithIncompleteSetup(const char* key, const LinkedWhatsAppBusinessAccountIdMetaData& value) { m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup.emplace(key, value); return *this; }
    ///@}
  private:

    Aws::String m_associateInProgressToken;
    bool m_associateInProgressTokenHasBeenSet = false;

    Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData> m_linkedAccountsWithIncompleteSetup;
    bool m_linkedAccountsWithIncompleteSetupHasBeenSet = false;
  };

} // namespace Model
} // namespace SocialMessaging
} // namespace Aws
