﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SSM
{
namespace Model
{
  class StartExecutionPreviewResult
  {
  public:
    AWS_SSM_API StartExecutionPreviewResult();
    AWS_SSM_API StartExecutionPreviewResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SSM_API StartExecutionPreviewResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The ID of the execution preview generated by the system.</p>
     */
    inline const Aws::String& GetExecutionPreviewId() const{ return m_executionPreviewId; }
    inline void SetExecutionPreviewId(const Aws::String& value) { m_executionPreviewId = value; }
    inline void SetExecutionPreviewId(Aws::String&& value) { m_executionPreviewId = std::move(value); }
    inline void SetExecutionPreviewId(const char* value) { m_executionPreviewId.assign(value); }
    inline StartExecutionPreviewResult& WithExecutionPreviewId(const Aws::String& value) { SetExecutionPreviewId(value); return *this;}
    inline StartExecutionPreviewResult& WithExecutionPreviewId(Aws::String&& value) { SetExecutionPreviewId(std::move(value)); return *this;}
    inline StartExecutionPreviewResult& WithExecutionPreviewId(const char* value) { SetExecutionPreviewId(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline StartExecutionPreviewResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline StartExecutionPreviewResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline StartExecutionPreviewResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_executionPreviewId;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SSM
} // namespace Aws
