﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/sso-admin/model/PermissionSetProvisioningStatusMetadata.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SSOAdmin
{
namespace Model
{
  class ListPermissionSetProvisioningStatusResult
  {
  public:
    AWS_SSOADMIN_API ListPermissionSetProvisioningStatusResult();
    AWS_SSOADMIN_API ListPermissionSetProvisioningStatusResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SSOADMIN_API ListPermissionSetProvisioningStatusResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The pagination token for the list API. Initially the value is null. Use the
     * output of previous API calls to make subsequent calls.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListPermissionSetProvisioningStatusResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListPermissionSetProvisioningStatusResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListPermissionSetProvisioningStatusResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The status object for the permission set provisioning operation.</p>
     */
    inline const Aws::Vector<PermissionSetProvisioningStatusMetadata>& GetPermissionSetsProvisioningStatus() const{ return m_permissionSetsProvisioningStatus; }
    inline void SetPermissionSetsProvisioningStatus(const Aws::Vector<PermissionSetProvisioningStatusMetadata>& value) { m_permissionSetsProvisioningStatus = value; }
    inline void SetPermissionSetsProvisioningStatus(Aws::Vector<PermissionSetProvisioningStatusMetadata>&& value) { m_permissionSetsProvisioningStatus = std::move(value); }
    inline ListPermissionSetProvisioningStatusResult& WithPermissionSetsProvisioningStatus(const Aws::Vector<PermissionSetProvisioningStatusMetadata>& value) { SetPermissionSetsProvisioningStatus(value); return *this;}
    inline ListPermissionSetProvisioningStatusResult& WithPermissionSetsProvisioningStatus(Aws::Vector<PermissionSetProvisioningStatusMetadata>&& value) { SetPermissionSetsProvisioningStatus(std::move(value)); return *this;}
    inline ListPermissionSetProvisioningStatusResult& AddPermissionSetsProvisioningStatus(const PermissionSetProvisioningStatusMetadata& value) { m_permissionSetsProvisioningStatus.push_back(value); return *this; }
    inline ListPermissionSetProvisioningStatusResult& AddPermissionSetsProvisioningStatus(PermissionSetProvisioningStatusMetadata&& value) { m_permissionSetsProvisioningStatus.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListPermissionSetProvisioningStatusResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListPermissionSetProvisioningStatusResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListPermissionSetProvisioningStatusResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;

    Aws::Vector<PermissionSetProvisioningStatusMetadata> m_permissionSetsProvisioningStatus;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SSOAdmin
} // namespace Aws
