﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sso-oidc/SSOOIDC_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SSOOIDC
{
namespace Model
{
  class CreateTokenResult
  {
  public:
    AWS_SSOOIDC_API CreateTokenResult();
    AWS_SSOOIDC_API CreateTokenResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SSOOIDC_API CreateTokenResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A bearer token to access Amazon Web Services accounts and applications
     * assigned to a user.</p>
     */
    inline const Aws::String& GetAccessToken() const{ return m_accessToken; }
    inline void SetAccessToken(const Aws::String& value) { m_accessToken = value; }
    inline void SetAccessToken(Aws::String&& value) { m_accessToken = std::move(value); }
    inline void SetAccessToken(const char* value) { m_accessToken.assign(value); }
    inline CreateTokenResult& WithAccessToken(const Aws::String& value) { SetAccessToken(value); return *this;}
    inline CreateTokenResult& WithAccessToken(Aws::String&& value) { SetAccessToken(std::move(value)); return *this;}
    inline CreateTokenResult& WithAccessToken(const char* value) { SetAccessToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Used to notify the client that the returned token is an access token. The
     * supported token type is <code>Bearer</code>.</p>
     */
    inline const Aws::String& GetTokenType() const{ return m_tokenType; }
    inline void SetTokenType(const Aws::String& value) { m_tokenType = value; }
    inline void SetTokenType(Aws::String&& value) { m_tokenType = std::move(value); }
    inline void SetTokenType(const char* value) { m_tokenType.assign(value); }
    inline CreateTokenResult& WithTokenType(const Aws::String& value) { SetTokenType(value); return *this;}
    inline CreateTokenResult& WithTokenType(Aws::String&& value) { SetTokenType(std::move(value)); return *this;}
    inline CreateTokenResult& WithTokenType(const char* value) { SetTokenType(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates the time in seconds when an access token will expire.</p>
     */
    inline int GetExpiresIn() const{ return m_expiresIn; }
    inline void SetExpiresIn(int value) { m_expiresIn = value; }
    inline CreateTokenResult& WithExpiresIn(int value) { SetExpiresIn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A token that, if present, can be used to refresh a previously issued access
     * token that might have expired.</p> <p>For more information about the features
     * and limitations of the current IAM Identity Center OIDC implementation, see
     * <i>Considerations for Using this Guide</i> in the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM
     * Identity Center OIDC API Reference</a>.</p>
     */
    inline const Aws::String& GetRefreshToken() const{ return m_refreshToken; }
    inline void SetRefreshToken(const Aws::String& value) { m_refreshToken = value; }
    inline void SetRefreshToken(Aws::String&& value) { m_refreshToken = std::move(value); }
    inline void SetRefreshToken(const char* value) { m_refreshToken.assign(value); }
    inline CreateTokenResult& WithRefreshToken(const Aws::String& value) { SetRefreshToken(value); return *this;}
    inline CreateTokenResult& WithRefreshToken(Aws::String&& value) { SetRefreshToken(std::move(value)); return *this;}
    inline CreateTokenResult& WithRefreshToken(const char* value) { SetRefreshToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The <code>idToken</code> is not implemented or supported. For more
     * information about the features and limitations of the current IAM Identity
     * Center OIDC implementation, see <i>Considerations for Using this Guide</i> in
     * the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM
     * Identity Center OIDC API Reference</a>.</p> <p>A JSON Web Token (JWT) that
     * identifies who is associated with the issued access token. </p>
     */
    inline const Aws::String& GetIdToken() const{ return m_idToken; }
    inline void SetIdToken(const Aws::String& value) { m_idToken = value; }
    inline void SetIdToken(Aws::String&& value) { m_idToken = std::move(value); }
    inline void SetIdToken(const char* value) { m_idToken.assign(value); }
    inline CreateTokenResult& WithIdToken(const Aws::String& value) { SetIdToken(value); return *this;}
    inline CreateTokenResult& WithIdToken(Aws::String&& value) { SetIdToken(std::move(value)); return *this;}
    inline CreateTokenResult& WithIdToken(const char* value) { SetIdToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline CreateTokenResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline CreateTokenResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline CreateTokenResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_accessToken;

    Aws::String m_tokenType;

    int m_expiresIn;

    Aws::String m_refreshToken;

    Aws::String m_idToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SSOOIDC
} // namespace Aws
