﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/swf/model/ActivityTypeInfo.h>
#include <aws/swf/model/ActivityTypeConfiguration.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SWF
{
namespace Model
{
  /**
   * <p>Detailed information about an activity type.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/ActivityTypeDetail">AWS
   * API Reference</a></p>
   */
  class DescribeActivityTypeResult
  {
  public:
    AWS_SWF_API DescribeActivityTypeResult();
    AWS_SWF_API DescribeActivityTypeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SWF_API DescribeActivityTypeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>General information about the activity type.</p> <p>The status of activity
     * type (returned in the ActivityTypeInfo structure) can be one of the
     * following.</p> <ul> <li> <p> <code>REGISTERED</code> – The type is registered
     * and available. Workers supporting this type should be running. </p> </li> <li>
     * <p> <code>DEPRECATED</code> – The type was deprecated using
     * <a>DeprecateActivityType</a>, but is still in use. You should keep workers
     * supporting this type running. You cannot create new tasks of this type. </p>
     * </li> </ul>
     */
    inline const ActivityTypeInfo& GetTypeInfo() const{ return m_typeInfo; }
    inline void SetTypeInfo(const ActivityTypeInfo& value) { m_typeInfo = value; }
    inline void SetTypeInfo(ActivityTypeInfo&& value) { m_typeInfo = std::move(value); }
    inline DescribeActivityTypeResult& WithTypeInfo(const ActivityTypeInfo& value) { SetTypeInfo(value); return *this;}
    inline DescribeActivityTypeResult& WithTypeInfo(ActivityTypeInfo&& value) { SetTypeInfo(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The configuration settings registered with the activity type.</p>
     */
    inline const ActivityTypeConfiguration& GetConfiguration() const{ return m_configuration; }
    inline void SetConfiguration(const ActivityTypeConfiguration& value) { m_configuration = value; }
    inline void SetConfiguration(ActivityTypeConfiguration&& value) { m_configuration = std::move(value); }
    inline DescribeActivityTypeResult& WithConfiguration(const ActivityTypeConfiguration& value) { SetConfiguration(value); return *this;}
    inline DescribeActivityTypeResult& WithConfiguration(ActivityTypeConfiguration&& value) { SetConfiguration(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DescribeActivityTypeResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DescribeActivityTypeResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DescribeActivityTypeResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    ActivityTypeInfo m_typeInfo;

    ActivityTypeConfiguration m_configuration;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace SWF
} // namespace Aws
