﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/swf/SWFRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/swf/model/TaskList.h>
#include <aws/swf/model/Decision.h>
#include <utility>

namespace Aws
{
namespace SWF
{
namespace Model
{

  /**
   * <p>Input data for a TaskCompleted response to a decision task.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/RespondDecisionTaskCompletedInput">AWS
   * API Reference</a></p>
   */
  class RespondDecisionTaskCompletedRequest : public SWFRequest
  {
  public:
    AWS_SWF_API RespondDecisionTaskCompletedRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "RespondDecisionTaskCompleted"; }

    AWS_SWF_API Aws::String SerializePayload() const override;

    AWS_SWF_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    ///@{
    /**
     * <p>The <code>taskToken</code> from the <a>DecisionTask</a>.</p>  <p>
     * <code>taskToken</code> is generated by the service and should be treated as an
     * opaque value. If the task is passed to another process, its
     * <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</p> 
     */
    inline const Aws::String& GetTaskToken() const{ return m_taskToken; }
    inline bool TaskTokenHasBeenSet() const { return m_taskTokenHasBeenSet; }
    inline void SetTaskToken(const Aws::String& value) { m_taskTokenHasBeenSet = true; m_taskToken = value; }
    inline void SetTaskToken(Aws::String&& value) { m_taskTokenHasBeenSet = true; m_taskToken = std::move(value); }
    inline void SetTaskToken(const char* value) { m_taskTokenHasBeenSet = true; m_taskToken.assign(value); }
    inline RespondDecisionTaskCompletedRequest& WithTaskToken(const Aws::String& value) { SetTaskToken(value); return *this;}
    inline RespondDecisionTaskCompletedRequest& WithTaskToken(Aws::String&& value) { SetTaskToken(std::move(value)); return *this;}
    inline RespondDecisionTaskCompletedRequest& WithTaskToken(const char* value) { SetTaskToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The list of decisions (possibly empty) made by the decider while processing
     * this decision task. See the docs for the <a>Decision</a> structure for
     * details.</p>
     */
    inline const Aws::Vector<Decision>& GetDecisions() const{ return m_decisions; }
    inline bool DecisionsHasBeenSet() const { return m_decisionsHasBeenSet; }
    inline void SetDecisions(const Aws::Vector<Decision>& value) { m_decisionsHasBeenSet = true; m_decisions = value; }
    inline void SetDecisions(Aws::Vector<Decision>&& value) { m_decisionsHasBeenSet = true; m_decisions = std::move(value); }
    inline RespondDecisionTaskCompletedRequest& WithDecisions(const Aws::Vector<Decision>& value) { SetDecisions(value); return *this;}
    inline RespondDecisionTaskCompletedRequest& WithDecisions(Aws::Vector<Decision>&& value) { SetDecisions(std::move(value)); return *this;}
    inline RespondDecisionTaskCompletedRequest& AddDecisions(const Decision& value) { m_decisionsHasBeenSet = true; m_decisions.push_back(value); return *this; }
    inline RespondDecisionTaskCompletedRequest& AddDecisions(Decision&& value) { m_decisionsHasBeenSet = true; m_decisions.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>User defined context to add to workflow execution.</p>
     */
    inline const Aws::String& GetExecutionContext() const{ return m_executionContext; }
    inline bool ExecutionContextHasBeenSet() const { return m_executionContextHasBeenSet; }
    inline void SetExecutionContext(const Aws::String& value) { m_executionContextHasBeenSet = true; m_executionContext = value; }
    inline void SetExecutionContext(Aws::String&& value) { m_executionContextHasBeenSet = true; m_executionContext = std::move(value); }
    inline void SetExecutionContext(const char* value) { m_executionContextHasBeenSet = true; m_executionContext.assign(value); }
    inline RespondDecisionTaskCompletedRequest& WithExecutionContext(const Aws::String& value) { SetExecutionContext(value); return *this;}
    inline RespondDecisionTaskCompletedRequest& WithExecutionContext(Aws::String&& value) { SetExecutionContext(std::move(value)); return *this;}
    inline RespondDecisionTaskCompletedRequest& WithExecutionContext(const char* value) { SetExecutionContext(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The task list to use for the future decision tasks of this workflow
     * execution. This list overrides the original task list you specified while
     * starting the workflow execution. </p>
     */
    inline const TaskList& GetTaskList() const{ return m_taskList; }
    inline bool TaskListHasBeenSet() const { return m_taskListHasBeenSet; }
    inline void SetTaskList(const TaskList& value) { m_taskListHasBeenSet = true; m_taskList = value; }
    inline void SetTaskList(TaskList&& value) { m_taskListHasBeenSet = true; m_taskList = std::move(value); }
    inline RespondDecisionTaskCompletedRequest& WithTaskList(const TaskList& value) { SetTaskList(value); return *this;}
    inline RespondDecisionTaskCompletedRequest& WithTaskList(TaskList&& value) { SetTaskList(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Specifies a timeout (in seconds) for the task list override. When this
     * parameter is missing, the task list override is permanent. This parameter makes
     * it possible to temporarily override the task list. If a decision task scheduled
     * on the override task list is not started within the timeout, the decision task
     * will time out. Amazon SWF will revert the override and schedule a new decision
     * task to the original task list.</p> <p>If a decision task scheduled on the
     * override task list is started within the timeout, but not completed within the
     * start-to-close timeout, Amazon SWF will also revert the override and schedule a
     * new decision task to the original task list.</p>
     */
    inline const Aws::String& GetTaskListScheduleToStartTimeout() const{ return m_taskListScheduleToStartTimeout; }
    inline bool TaskListScheduleToStartTimeoutHasBeenSet() const { return m_taskListScheduleToStartTimeoutHasBeenSet; }
    inline void SetTaskListScheduleToStartTimeout(const Aws::String& value) { m_taskListScheduleToStartTimeoutHasBeenSet = true; m_taskListScheduleToStartTimeout = value; }
    inline void SetTaskListScheduleToStartTimeout(Aws::String&& value) { m_taskListScheduleToStartTimeoutHasBeenSet = true; m_taskListScheduleToStartTimeout = std::move(value); }
    inline void SetTaskListScheduleToStartTimeout(const char* value) { m_taskListScheduleToStartTimeoutHasBeenSet = true; m_taskListScheduleToStartTimeout.assign(value); }
    inline RespondDecisionTaskCompletedRequest& WithTaskListScheduleToStartTimeout(const Aws::String& value) { SetTaskListScheduleToStartTimeout(value); return *this;}
    inline RespondDecisionTaskCompletedRequest& WithTaskListScheduleToStartTimeout(Aws::String&& value) { SetTaskListScheduleToStartTimeout(std::move(value)); return *this;}
    inline RespondDecisionTaskCompletedRequest& WithTaskListScheduleToStartTimeout(const char* value) { SetTaskListScheduleToStartTimeout(value); return *this;}
    ///@}
  private:

    Aws::String m_taskToken;
    bool m_taskTokenHasBeenSet = false;

    Aws::Vector<Decision> m_decisions;
    bool m_decisionsHasBeenSet = false;

    Aws::String m_executionContext;
    bool m_executionContextHasBeenSet = false;

    TaskList m_taskList;
    bool m_taskListHasBeenSet = false;

    Aws::String m_taskListScheduleToStartTimeout;
    bool m_taskListScheduleToStartTimeoutHasBeenSet = false;
  };

} // namespace Model
} // namespace SWF
} // namespace Aws
