﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/vpc-lattice/VPCLattice_EXPORTS.h>
#include <aws/vpc-lattice/VPCLatticeRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace VPCLattice
{
namespace Model
{

  /**
   */
  class DeleteServiceNetworkServiceAssociationRequest : public VPCLatticeRequest
  {
  public:
    AWS_VPCLATTICE_API DeleteServiceNetworkServiceAssociationRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DeleteServiceNetworkServiceAssociation"; }

    AWS_VPCLATTICE_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The ID or ARN of the association.</p>
     */
    inline const Aws::String& GetServiceNetworkServiceAssociationIdentifier() const{ return m_serviceNetworkServiceAssociationIdentifier; }
    inline bool ServiceNetworkServiceAssociationIdentifierHasBeenSet() const { return m_serviceNetworkServiceAssociationIdentifierHasBeenSet; }
    inline void SetServiceNetworkServiceAssociationIdentifier(const Aws::String& value) { m_serviceNetworkServiceAssociationIdentifierHasBeenSet = true; m_serviceNetworkServiceAssociationIdentifier = value; }
    inline void SetServiceNetworkServiceAssociationIdentifier(Aws::String&& value) { m_serviceNetworkServiceAssociationIdentifierHasBeenSet = true; m_serviceNetworkServiceAssociationIdentifier = std::move(value); }
    inline void SetServiceNetworkServiceAssociationIdentifier(const char* value) { m_serviceNetworkServiceAssociationIdentifierHasBeenSet = true; m_serviceNetworkServiceAssociationIdentifier.assign(value); }
    inline DeleteServiceNetworkServiceAssociationRequest& WithServiceNetworkServiceAssociationIdentifier(const Aws::String& value) { SetServiceNetworkServiceAssociationIdentifier(value); return *this;}
    inline DeleteServiceNetworkServiceAssociationRequest& WithServiceNetworkServiceAssociationIdentifier(Aws::String&& value) { SetServiceNetworkServiceAssociationIdentifier(std::move(value)); return *this;}
    inline DeleteServiceNetworkServiceAssociationRequest& WithServiceNetworkServiceAssociationIdentifier(const char* value) { SetServiceNetworkServiceAssociationIdentifier(value); return *this;}
    ///@}
  private:

    Aws::String m_serviceNetworkServiceAssociationIdentifier;
    bool m_serviceNetworkServiceAssociationIdentifierHasBeenSet = false;
  };

} // namespace Model
} // namespace VPCLattice
} // namespace Aws
