﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/model/ReviewTemplateAnswer.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace WellArchitected
{
namespace Model
{
  class UpdateReviewTemplateAnswerResult
  {
  public:
    AWS_WELLARCHITECTED_API UpdateReviewTemplateAnswerResult();
    AWS_WELLARCHITECTED_API UpdateReviewTemplateAnswerResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_WELLARCHITECTED_API UpdateReviewTemplateAnswerResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The review template ARN.</p>
     */
    inline const Aws::String& GetTemplateArn() const{ return m_templateArn; }
    inline void SetTemplateArn(const Aws::String& value) { m_templateArn = value; }
    inline void SetTemplateArn(Aws::String&& value) { m_templateArn = std::move(value); }
    inline void SetTemplateArn(const char* value) { m_templateArn.assign(value); }
    inline UpdateReviewTemplateAnswerResult& WithTemplateArn(const Aws::String& value) { SetTemplateArn(value); return *this;}
    inline UpdateReviewTemplateAnswerResult& WithTemplateArn(Aws::String&& value) { SetTemplateArn(std::move(value)); return *this;}
    inline UpdateReviewTemplateAnswerResult& WithTemplateArn(const char* value) { SetTemplateArn(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetLensAlias() const{ return m_lensAlias; }
    inline void SetLensAlias(const Aws::String& value) { m_lensAlias = value; }
    inline void SetLensAlias(Aws::String&& value) { m_lensAlias = std::move(value); }
    inline void SetLensAlias(const char* value) { m_lensAlias.assign(value); }
    inline UpdateReviewTemplateAnswerResult& WithLensAlias(const Aws::String& value) { SetLensAlias(value); return *this;}
    inline UpdateReviewTemplateAnswerResult& WithLensAlias(Aws::String&& value) { SetLensAlias(std::move(value)); return *this;}
    inline UpdateReviewTemplateAnswerResult& WithLensAlias(const char* value) { SetLensAlias(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>An answer of the question.</p>
     */
    inline const ReviewTemplateAnswer& GetAnswer() const{ return m_answer; }
    inline void SetAnswer(const ReviewTemplateAnswer& value) { m_answer = value; }
    inline void SetAnswer(ReviewTemplateAnswer&& value) { m_answer = std::move(value); }
    inline UpdateReviewTemplateAnswerResult& WithAnswer(const ReviewTemplateAnswer& value) { SetAnswer(value); return *this;}
    inline UpdateReviewTemplateAnswerResult& WithAnswer(ReviewTemplateAnswer&& value) { SetAnswer(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline UpdateReviewTemplateAnswerResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline UpdateReviewTemplateAnswerResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline UpdateReviewTemplateAnswerResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_templateArn;

    Aws::String m_lensAlias;

    ReviewTemplateAnswer m_answer;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace WellArchitected
} // namespace Aws
