﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace WorkSpaces
{
namespace Model
{

  /**
   * <p>Describes the network details of a WorkSpaces Pool.</p><p><h3>See Also:</h3> 
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/NetworkAccessConfiguration">AWS
   * API Reference</a></p>
   */
  class NetworkAccessConfiguration
  {
  public:
    AWS_WORKSPACES_API NetworkAccessConfiguration();
    AWS_WORKSPACES_API NetworkAccessConfiguration(Aws::Utils::Json::JsonView jsonValue);
    AWS_WORKSPACES_API NetworkAccessConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_WORKSPACES_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The private IP address of the elastic network interface that is attached to
     * instances in your VPC.</p>
     */
    inline const Aws::String& GetEniPrivateIpAddress() const{ return m_eniPrivateIpAddress; }
    inline bool EniPrivateIpAddressHasBeenSet() const { return m_eniPrivateIpAddressHasBeenSet; }
    inline void SetEniPrivateIpAddress(const Aws::String& value) { m_eniPrivateIpAddressHasBeenSet = true; m_eniPrivateIpAddress = value; }
    inline void SetEniPrivateIpAddress(Aws::String&& value) { m_eniPrivateIpAddressHasBeenSet = true; m_eniPrivateIpAddress = std::move(value); }
    inline void SetEniPrivateIpAddress(const char* value) { m_eniPrivateIpAddressHasBeenSet = true; m_eniPrivateIpAddress.assign(value); }
    inline NetworkAccessConfiguration& WithEniPrivateIpAddress(const Aws::String& value) { SetEniPrivateIpAddress(value); return *this;}
    inline NetworkAccessConfiguration& WithEniPrivateIpAddress(Aws::String&& value) { SetEniPrivateIpAddress(std::move(value)); return *this;}
    inline NetworkAccessConfiguration& WithEniPrivateIpAddress(const char* value) { SetEniPrivateIpAddress(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The resource identifier of the elastic network interface that is attached to
     * instances in your VPC. All network interfaces have the eni-xxxxxxxx resource
     * identifier.</p>
     */
    inline const Aws::String& GetEniId() const{ return m_eniId; }
    inline bool EniIdHasBeenSet() const { return m_eniIdHasBeenSet; }
    inline void SetEniId(const Aws::String& value) { m_eniIdHasBeenSet = true; m_eniId = value; }
    inline void SetEniId(Aws::String&& value) { m_eniIdHasBeenSet = true; m_eniId = std::move(value); }
    inline void SetEniId(const char* value) { m_eniIdHasBeenSet = true; m_eniId.assign(value); }
    inline NetworkAccessConfiguration& WithEniId(const Aws::String& value) { SetEniId(value); return *this;}
    inline NetworkAccessConfiguration& WithEniId(Aws::String&& value) { SetEniId(std::move(value)); return *this;}
    inline NetworkAccessConfiguration& WithEniId(const char* value) { SetEniId(value); return *this;}
    ///@}
  private:

    Aws::String m_eniPrivateIpAddress;
    bool m_eniPrivateIpAddressHasBeenSet = false;

    Aws::String m_eniId;
    bool m_eniIdHasBeenSet = false;
  };

} // namespace Model
} // namespace WorkSpaces
} // namespace Aws
