﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-runtime/BedrockRuntime_EXPORTS.h>
#include <aws/bedrock-runtime/model/GuardrailContextualGroundingFilterType.h>
#include <aws/bedrock-runtime/model/GuardrailContextualGroundingPolicyAction.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace BedrockRuntime
{
namespace Model
{

  /**
   * <p>The details for the guardrails contextual grounding filter.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/GuardrailContextualGroundingFilter">AWS
   * API Reference</a></p>
   */
  class GuardrailContextualGroundingFilter
  {
  public:
    AWS_BEDROCKRUNTIME_API GuardrailContextualGroundingFilter() = default;
    AWS_BEDROCKRUNTIME_API GuardrailContextualGroundingFilter(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKRUNTIME_API GuardrailContextualGroundingFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKRUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The contextual grounding filter type.</p>
     */
    inline GuardrailContextualGroundingFilterType GetType() const { return m_type; }
    inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
    inline void SetType(GuardrailContextualGroundingFilterType value) { m_typeHasBeenSet = true; m_type = value; }
    inline GuardrailContextualGroundingFilter& WithType(GuardrailContextualGroundingFilterType value) { SetType(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The threshold used by contextual grounding filter to determine whether the
     * content is grounded or not.</p>
     */
    inline double GetThreshold() const { return m_threshold; }
    inline bool ThresholdHasBeenSet() const { return m_thresholdHasBeenSet; }
    inline void SetThreshold(double value) { m_thresholdHasBeenSet = true; m_threshold = value; }
    inline GuardrailContextualGroundingFilter& WithThreshold(double value) { SetThreshold(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The score generated by contextual grounding filter.</p>
     */
    inline double GetScore() const { return m_score; }
    inline bool ScoreHasBeenSet() const { return m_scoreHasBeenSet; }
    inline void SetScore(double value) { m_scoreHasBeenSet = true; m_score = value; }
    inline GuardrailContextualGroundingFilter& WithScore(double value) { SetScore(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The action performed by the guardrails contextual grounding filter.</p>
     */
    inline GuardrailContextualGroundingPolicyAction GetAction() const { return m_action; }
    inline bool ActionHasBeenSet() const { return m_actionHasBeenSet; }
    inline void SetAction(GuardrailContextualGroundingPolicyAction value) { m_actionHasBeenSet = true; m_action = value; }
    inline GuardrailContextualGroundingFilter& WithAction(GuardrailContextualGroundingPolicyAction value) { SetAction(value); return *this;}
    ///@}
  private:

    GuardrailContextualGroundingFilterType m_type{GuardrailContextualGroundingFilterType::NOT_SET};
    bool m_typeHasBeenSet = false;

    double m_threshold{0.0};
    bool m_thresholdHasBeenSet = false;

    double m_score{0.0};
    bool m_scoreHasBeenSet = false;

    GuardrailContextualGroundingPolicyAction m_action{GuardrailContextualGroundingPolicyAction::NOT_SET};
    bool m_actionHasBeenSet = false;
  };

} // namespace Model
} // namespace BedrockRuntime
} // namespace Aws
